/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchSink;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.common.ReferencePluginConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceBatchSink<IN, KEY_OUT, VAL_OUT>
extends BatchSink<IN, KEY_OUT, VAL_OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceBatchSink.class);
    private final ReferencePluginConfig config;

    public ReferenceBatchSink(ReferencePluginConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        super.configurePipeline(pipelineConfigurer);
        FailureCollector collector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        IdUtils.validateReferenceName(this.config.referenceName, collector);
        collector.getOrThrowException();
    }

    protected void recordLineage(BatchSinkContext context, String outputName, Schema tableSchema, String operationName, String description) {
        if (tableSchema == null) {
            LOG.warn("Schema for output %s is null. Field-level lineage will not be recorded.", (Object)outputName);
            return;
        }
        if (tableSchema.getFields() == null) {
            LOG.warn("Schema fields for output %s is empty. Field-level lineage will not be recorded", (Object)outputName);
            return;
        }
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, outputName);
        lineageRecorder.createExternalDataset(tableSchema);
        List<String> fieldNames = tableSchema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList());
        if (!fieldNames.isEmpty()) {
            lineageRecorder.recordWrite(operationName, description, fieldNames);
        }
    }
}

