/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.base.Preconditions;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.table.Row;

public class RowRecordTransformer {
    private final Schema schema;
    private final Schema.Field rowField;

    public RowRecordTransformer(Schema schema, String rowFieldName) {
        this.validateSchema(schema);
        this.schema = schema;
        if (rowFieldName != null) {
            this.rowField = schema.getField(rowFieldName);
            Preconditions.checkArgument((this.rowField != null ? 1 : 0) != 0, (Object)"Row field must be present in the schema.");
            Preconditions.checkArgument((boolean)this.rowField.getSchema().getType().isSimpleType(), (Object)"Row field must be a simple type.");
        } else {
            this.rowField = null;
        }
    }

    public StructuredRecord toRecord(Row row) {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)this.schema);
        if (this.rowField != null) {
            this.setField(builder, this.rowField, row.getRow());
        }
        for (Schema.Field field : this.schema.getFields()) {
            if (this.rowField != null && field.getName().equals(this.rowField.getName())) continue;
            this.setField(builder, field, row.get(field.getName()));
        }
        return builder.build();
    }

    private void validateSchema(Schema schema) {
        Preconditions.checkArgument((schema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (Object)"Schema must be a record.");
        for (Schema.Field field : schema.getFields()) {
            Schema fieldSchema = field.getSchema();
            if (!(fieldSchema.isNullable() ? !fieldSchema.isNullableSimple() : !fieldSchema.getType().isSimpleType())) continue;
            throw new IllegalArgumentException(String.format("Unsupported type %s for field %s.", fieldSchema.getType(), field.getName()));
        }
    }

    private void setField(StructuredRecord.Builder builder, Schema.Field field, byte[] fieldBytes) {
        String fieldName = field.getName();
        Schema fieldSchema = field.getSchema();
        if (fieldBytes == null) {
            if (!fieldSchema.isNullable()) {
                throw new IllegalArgumentException("null value found for non-nullable field " + fieldName);
            }
            return;
        }
        Schema.Type fieldType = fieldSchema.isNullable() ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
        switch (fieldType) {
            case BOOLEAN: {
                builder.set(fieldName, (Object)Bytes.toBoolean((byte[])fieldBytes));
                break;
            }
            case INT: {
                builder.set(fieldName, (Object)Bytes.toInt((byte[])fieldBytes));
                break;
            }
            case LONG: {
                builder.set(fieldName, (Object)Bytes.toLong((byte[])fieldBytes));
                break;
            }
            case FLOAT: {
                builder.set(fieldName, (Object)Float.valueOf(Bytes.toFloat((byte[])fieldBytes)));
                break;
            }
            case DOUBLE: {
                builder.set(fieldName, (Object)Bytes.toDouble((byte[])fieldBytes));
                break;
            }
            case BYTES: {
                builder.set(fieldName, (Object)fieldBytes);
                break;
            }
            case STRING: {
                builder.set(fieldName, (Object)Bytes.toString((byte[])fieldBytes));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + fieldType + " for field " + fieldName);
            }
        }
    }
}

