/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.base.Strings;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaValidator.class);

    @Nullable
    public static Schema validateOutputSchemaAndInputSchemaIfPresent(String outputSchemaString, String rowKeyField, PipelineConfigurer pipelineConfigurer) {
        Schema outputSchema;
        Schema inputSchema = pipelineConfigurer.getStageConfigurer().getInputSchema();
        FailureCollector collector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        if (inputSchema == null && Strings.isNullOrEmpty((String)outputSchemaString)) {
            return null;
        }
        if (outputSchemaString == null) {
            outputSchema = inputSchema;
        } else {
            try {
                outputSchema = Schema.parseJson((String)outputSchemaString);
            }
            catch (IOException e) {
                collector.addFailure("Invalid schema : " + e.getMessage(), null).withConfigProperty("schema");
                throw collector.getOrThrowException();
            }
        }
        for (Schema.Field field : outputSchema.getFields()) {
            Schema nonNullableSchema = field.getSchema().isNullable() ? field.getSchema().getNonNullable() : field.getSchema();
            if (nonNullableSchema.isSimpleOrNullableSimple()) continue;
            collector.addFailure(String.format("Field '%s' is of unexpected type '%s'.", field.getName(), nonNullableSchema.getDisplayName()), "Supported types are : boolean, int, long, float, double, bytes, string.").withOutputSchemaField(field.getName()).withInputSchemaField(field.getName());
        }
        if (inputSchema != null) {
            SchemaValidator.validateOutputSchemaIsSubsetOfInputSchema(inputSchema, outputSchema, collector);
        }
        return outputSchema;
    }

    public static void validateOutputSchemaIsSubsetOfInputSchema(Schema inputSchema, Schema outputSchema) {
        for (Schema.Field field : outputSchema.getFields()) {
            if (inputSchema.getField(field.getName()) == null) {
                throw new IllegalArgumentException(String.format("Field '%s' is present in output schema but not present in input schema", field.getName()));
            }
            if (inputSchema.getField(field.getName()).getSchema().equals((Object)field.getSchema())) continue;
            throw new IllegalArgumentException(String.format("Field type mismatch, field '%s' type in input schema is %s, while in output schema its of type %s", field.getName(), inputSchema.getField(field.getName()).getSchema(), field.getSchema()));
        }
    }

    public static void validateOutputSchemaIsSubsetOfInputSchema(Schema inputSchema, Schema outputSchema, FailureCollector collector) {
        for (Schema.Field field : outputSchema.getFields()) {
            Schema fieldSchema;
            String fieldName = field.getName();
            if (inputSchema.getField(fieldName) == null) {
                collector.addFailure(String.format("Field '%s' is present in output schema but not present in input schema.", fieldName), null).withOutputSchemaField(fieldName);
                continue;
            }
            Schema inFieldSchema = inputSchema.getField(fieldName).getSchema();
            inFieldSchema = inFieldSchema.isNullable() ? inFieldSchema.getNonNullable() : inFieldSchema;
            if (inFieldSchema.equals((Object)(fieldSchema = field.getSchema().isNullable() ? field.getSchema().getNonNullable() : field.getSchema()))) continue;
            collector.addFailure(String.format("Field '%s' has type mismatch with input schema type '%s'.", fieldName, inFieldSchema.getDisplayName()), "Change type to match input schema type.").withOutputSchemaField(fieldName).withInputSchemaField(fieldName);
        }
    }

    public static void validateSchemaFieldsAreSimple(Schema schema) {
        for (Schema.Field field : schema.getFields()) {
            if (field.getSchema().isSimpleOrNullableSimple()) continue;
            throw new IllegalArgumentException(String.format("Field '%s' is not of simple type, All fields for table sink should of simple type", field.getName()));
        }
    }

    public static void validateFieldsArePresentInSchema(Schema schema, String ... requiredFields) {
        for (String field : requiredFields) {
            if (schema.getField(field) != null) continue;
            throw new IllegalArgumentException(String.format("Field : '%s' is not present in the input schema", field));
        }
    }

    public static boolean canRecordLineage(@Nullable Schema schema, String name) {
        if (schema == null) {
            LOG.debug(String.format("The %s schema is null. Field level lineage will not be recorded", name));
            return false;
        }
        if (schema.getFields() == null) {
            LOG.debug(String.format("The %s schema fields are null. Field level lineage will not be recorded", name));
            return false;
        }
        return true;
    }

    private SchemaValidator() {
        throw new AssertionError((Object)"Suppress default constructor for non-instantiability");
    }
}

