/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;

public class TimeParser {
    private final long runtime;

    public TimeParser(long runtime) {
        this.runtime = runtime;
    }

    public long parseRuntime(String str) {
        MathNode mathNode = this.parseExpression(str);
        return mathNode.evaluate();
    }

    public static long parseDuration(String durationStr) {
        long parsedValue;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)durationStr) ? 1 : 0) != 0);
        durationStr = durationStr.trim().toLowerCase();
        String value = durationStr.substring(0, durationStr.length() - 1);
        try {
            parsedValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Error parsing the duration string %s. Cannot parse %s as a long", durationStr, value));
        }
        char lastChar = durationStr.charAt(durationStr.length() - 1);
        switch (lastChar) {
            case 's': {
                return TimeUnit.SECONDS.toMillis(parsedValue);
            }
            case 'm': {
                return TimeUnit.MINUTES.toMillis(parsedValue);
            }
            case 'h': {
                return TimeUnit.HOURS.toMillis(parsedValue);
            }
            case 'd': {
                return TimeUnit.DAYS.toMillis(parsedValue);
            }
        }
        throw new IllegalArgumentException(String.format("Time unit not supported: %s", Character.valueOf(lastChar)));
    }

    private MathNode parseExpression(String expression) {
        int idx = Math.max((expression = expression.trim()).lastIndexOf(43), expression.lastIndexOf(45));
        if (idx < 0) {
            return "runtime".equals(expression) ? new ValueNode(this.runtime) : new ValueNode(TimeParser.parseDuration(expression));
        }
        char operator = expression.charAt(idx);
        if (idx == expression.length()) {
            throw new IllegalArgumentException(String.format("Invalid expression '%s'. Cannot end with %s.", expression, Character.valueOf(operator)));
        }
        if (idx == 0) {
            return new ValueNode(TimeParser.parseDuration(expression));
        }
        MathNode left = this.parseExpression(expression.substring(0, idx));
        MathNode right = this.parseExpression(expression.substring(idx + 1));
        if (operator == '+') {
            return new AddNode(left, right);
        }
        return new SubtractNode(left, right);
    }

    private static class SubtractNode
    implements MathNode {
        private final MathNode left;
        private final MathNode right;

        SubtractNode(MathNode left, MathNode right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public long evaluate() {
            return this.left.evaluate() - this.right.evaluate();
        }
    }

    private static class AddNode
    implements MathNode {
        private final MathNode left;
        private final MathNode right;

        AddNode(MathNode left, MathNode right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public long evaluate() {
            return this.left.evaluate() + this.right.evaluate();
        }
    }

    private static class ValueNode
    implements MathNode {
        private long value;

        ValueNode(long value) {
            this.value = value;
        }

        @Override
        public long evaluate() {
            return this.value;
        }
    }

    private static interface MathNode {
        public long evaluate();
    }
}

