/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.lineage.field.FieldOperation;
import io.cdap.cdap.etl.api.lineage.field.FieldTransformOperation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TransformLineageRecorderUtils {
    public static final String IDENTITY_TRANSFORM_DESCRIPTION = "Unchanged fields in the transform.";
    public static final String DROP_TRANSFORM_DESCRIPTION = "Dropped fields not included in the output.";

    private TransformLineageRecorderUtils() {
    }

    public static List<String> getFields(@Nullable Schema schema) {
        if (schema == null || schema.getFields() == null || schema.getFields().isEmpty()) {
            return Collections.emptyList();
        }
        return schema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList());
    }

    public static List<FieldOperation> generateOneToOnes(List<String> input, String name, String description) {
        return input.stream().map(inputField -> new FieldTransformOperation(name + "_" + inputField, description, Collections.singletonList(inputField), Collections.singletonList(inputField))).collect(Collectors.toList());
    }

    public static List<FieldOperation> generateDrops(List<String> input) {
        return input.stream().map(inputField -> new FieldTransformOperation("drop_" + inputField, DROP_TRANSFORM_DESCRIPTION, Collections.singletonList(inputField), Collections.emptyList())).collect(Collectors.toList());
    }

    public static List<FieldOperation> generateManyToOne(List<String> input, String output, String name, String description) {
        return Collections.singletonList(new FieldTransformOperation(name, description, input, new String[]{output}));
    }

    public static List<FieldOperation> generateOneToMany(String input, List<String> output, String name, String description) {
        return Collections.singletonList(new FieldTransformOperation(name, description, Collections.singletonList(input), output));
    }

    public static List<FieldOperation> generateManyToMany(List<String> input, List<String> output, String name, String description) {
        return Collections.singletonList(new FieldTransformOperation(name, description, input, output));
    }

    public static List<FieldOperation> generateOneToOne(String input, String output, String name, String description) {
        return Collections.singletonList(new FieldTransformOperation(name, description, Collections.singletonList(input), new String[]{output}));
    }
}

