/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.batch;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static Map<String, String> getNonDefaultConfigurations(Configuration modifiedConf) {
        MapDifference mapDifference = Maps.difference(ConfigurationUtils.getConfigurationAsMap(new Configuration()), ConfigurationUtils.getConfigurationAsMap(modifiedConf));
        Map newEntries = mapDifference.entriesOnlyOnRight();
        Map stringValueDifferenceMap = mapDifference.entriesDiffering();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry stringValueDifferenceEntry : stringValueDifferenceMap.entrySet()) {
            result.put((String)stringValueDifferenceEntry.getKey(), (String)((MapDifference.ValueDifference)stringValueDifferenceEntry.getValue()).rightValue());
        }
        result.putAll(newEntries);
        return result;
    }

    private static Map<String, String> getConfigurationAsMap(Configuration conf) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }
}

