/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.batch;

import io.cdap.plugin.common.CombineClassLoader;
import io.cdap.plugin.common.batch.ThrowableFunction;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public final class JobUtils {
    public static Job createInstance() throws IOException {
        Job job = Job.getInstance();
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
            job.getCredentials().addAll(credentials);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T applyWithExtraClassLoader(JobContext job, ClassLoader extraClassLoader, ThrowableFunction<JobContext, T, E> f) throws E {
        Configuration hConf = job.getConfiguration();
        ClassLoader cl = hConf.getClassLoader();
        hConf.setClassLoader((ClassLoader)new CombineClassLoader(cl, extraClassLoader));
        try {
            T t = f.apply(job);
            return t;
        }
        finally {
            hConf.setClassLoader(cl);
        }
    }

    private JobUtils() {
    }
}

