/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.batch.action;

import com.google.common.base.Joiner;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.batch.BatchActionContext;
import io.cdap.plugin.common.batch.action.Condition;
import javax.annotation.Nullable;

public class ConditionConfig
extends PluginConfig {
    protected static final String NAME_RUN_CONDITION = "runCondition";
    @Nullable
    @Description(value="When to run the action. Must be 'completion', 'success', or 'failure'. Defaults to 'completion'. If set to 'completion', the action will be executed regardless of whether the pipeline run succeeded or failed.If set to 'success', the action will only be executed if the pipeline run succeeded. If set to 'failure', the action will only be executed if the pipeline run failed.")
    public String runCondition;

    public ConditionConfig() {
        this.runCondition = Condition.COMPLETION.name();
    }

    public ConditionConfig(String runCondition) {
        this.runCondition = runCondition;
    }

    @Deprecated
    public void validate() {
        try {
            Condition.valueOf(this.runCondition.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid runCondition value '%s'.  Must be one of %s.", this.runCondition, Joiner.on((char)',').join((Object[])Condition.values())));
        }
    }

    public void validate(FailureCollector collector) {
        try {
            Condition.valueOf(this.runCondition.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            collector.addFailure(String.format("Invalid runCondition value '%s'.  Must be one of %s.", this.runCondition, Joiner.on((char)',').join((Object[])Condition.values())), "").withConfigProperty(NAME_RUN_CONDITION);
        }
    }

    public boolean shouldRun(BatchActionContext actionContext) {
        Condition condition = Condition.valueOf(this.runCondition.toUpperCase());
        switch (condition) {
            case COMPLETION: {
                return true;
            }
            case SUCCESS: {
                return actionContext.isSuccessful();
            }
            case FAILURE: {
                return !actionContext.isSuccessful();
            }
        }
        throw new IllegalStateException("Unknown value for runCondition: " + this.runCondition);
    }
}

