/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.batch.sink;

import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.plugin.common.batch.ConfigurationUtils;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.OutputFormat;

public final class SinkOutputFormatProvider
implements OutputFormatProvider {
    private final String outputFormatClassName;
    private final Map<String, String> configuration;

    public SinkOutputFormatProvider(Class<? extends OutputFormat> outputFormatClass, Configuration hConf) {
        this(outputFormatClass.getName(), hConf);
    }

    public SinkOutputFormatProvider(String outputFormatClassName, Configuration hConf) {
        this.outputFormatClassName = outputFormatClassName;
        this.configuration = ConfigurationUtils.getNonDefaultConfigurations(hConf);
    }

    public SinkOutputFormatProvider(String outputFormatClassName, Map<String, String> configuration) {
        this.outputFormatClassName = outputFormatClassName;
        this.configuration = ImmutableMap.copyOf(configuration);
    }

    public String getOutputFormatClassName() {
        return this.outputFormatClassName;
    }

    public Map<String, String> getOutputFormatConfiguration() {
        return this.configuration;
    }
}

