/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.http;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class HTTPConfig
extends PluginConfig {
    private static final String KV_DELIMITER = ":";
    private static final String DELIMITER = "\n";
    private static final String NAME_URL = "url";
    private static final String NAME_REQUEST_HEADERS = "requestHeaders";
    private static final String NAME_CONNECTION_TIMEOUT = "connectTimeout";
    @Description(value="The URL to fetch data from.")
    @Macro
    private String url;
    @Description(value="Request headers to set when performing the http request.")
    @Nullable
    @Macro
    private String requestHeaders;
    @Description(value="Whether to automatically follow redirects. Defaults to true.")
    @Nullable
    @Macro
    private Boolean followRedirects;
    @Description(value="Sets the connection timeout in milliseconds. Set to 0 for infinite. Default is 60000 (1 minute).")
    @Nullable
    @Macro
    private Integer connectTimeout;

    public HTTPConfig() {
        this(null, null);
    }

    public HTTPConfig(String url, String requestHeaders) {
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.followRedirects = true;
        this.connectTimeout = 60000;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getRequestHeadersMap() {
        return this.convertHeadersToMap(this.requestHeaders);
    }

    public boolean shouldFollowRedirects() {
        return this.followRedirects;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public void validate() {
        this.validateURL();
        this.validateConnectionTimeout();
        this.validateRequestHeaders();
    }

    public void validate(FailureCollector collector) {
        try {
            this.validateURL();
        }
        catch (IllegalArgumentException e) {
            collector.addFailure(String.format("URL '%s' is malformed: %s", this.url, e.getMessage()), "Specify a valid url.").withConfigProperty(NAME_URL).withStacktrace(e.getStackTrace());
        }
        try {
            this.validateConnectionTimeout();
        }
        catch (IllegalArgumentException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_CONNECTION_TIMEOUT);
        }
        this.convertHeadersToMap(this.requestHeaders, collector);
    }

    private Map<String, String> convertHeadersToMap(String headersString) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)headersString)) {
            for (String chunk : headersString.split(DELIMITER)) {
                String[] keyValue = chunk.split(KV_DELIMITER, 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException(String.format("Unable to parse key-value pair '%s'.", chunk));
                }
                headersMap.put(keyValue[0], keyValue[1]);
            }
        }
        return headersMap;
    }

    private void validateURL() {
        if (!this.containsMacro(NAME_URL) && !Strings.isNullOrEmpty((String)this.url)) {
            try {
                new URL(this.url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format("URL '%s' is malformed: %s", this.url, e.getMessage()), e);
            }
        }
    }

    private void validateConnectionTimeout() {
        if (!this.containsMacro(NAME_CONNECTION_TIMEOUT) && this.connectTimeout != null && this.connectTimeout < 0) {
            throw new IllegalArgumentException(String.format("Invalid connectTimeout '%d'. Timeout must be 0 or a positive number.", this.connectTimeout));
        }
    }

    private void validateRequestHeaders() {
        if (!this.containsMacro(NAME_REQUEST_HEADERS)) {
            this.convertHeadersToMap(this.requestHeaders);
        }
    }

    private Map<String, String> convertHeadersToMap(String headersString, FailureCollector collector) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)headersString)) {
            for (String chunk : headersString.split(DELIMITER)) {
                String[] keyValue = chunk.split(KV_DELIMITER, 2);
                if (keyValue.length == 2) {
                    headersMap.put(keyValue[0], keyValue[1]);
                    continue;
                }
                collector.addFailure(String.format("Unable to parse key-value pair '%s'.", chunk), String.format("Ensure request headers are specified in <key>%s<value> format", KV_DELIMITER)).withConfigElement(NAME_REQUEST_HEADERS, chunk);
            }
        }
        return headersMap;
    }
}

