/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.http;

import com.google.common.base.Charsets;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.http.HTTPConfig;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.annotation.Nullable;

public class HTTPPollConfig
extends HTTPConfig {
    private static final String NAME_INTERVAL = "interval";
    private static final String NAME_READ_TIMEOUT = "readTimeout";
    private static final String NAME_CHARSET = "charset";
    @Name(value="referenceName")
    @Description(value="This will be used to uniquely identify this source/sink for lineage, annotating metadata, etc.")
    public String referenceName;
    @Name(value="interval")
    @Description(value="The amount of time to wait between each poll in seconds.")
    private long interval;
    @Name(value="charset")
    @Description(value="The charset used to decode the response. Defaults to UTF-8.")
    @Nullable
    private String charset;
    @Name(value="readTimeout")
    @Description(value="Sets the read timeout in milliseconds. Set to 0 for infinite. Default is 60000 (1 minute).")
    @Nullable
    private Integer readTimeout;

    public HTTPPollConfig() {
        this("", null, 60L);
    }

    public HTTPPollConfig(String referenceName, String url, long interval) {
        this(referenceName, url, interval, null);
    }

    public HTTPPollConfig(String referenceName, String url, long interval, String requestHeaders) {
        super(url, requestHeaders);
        this.interval = interval;
        this.charset = Charsets.UTF_8.name();
        this.readTimeout = 60000;
        this.referenceName = referenceName;
    }

    public long getInterval() {
        return this.interval;
    }

    public Charset getCharset() {
        return Charset.forName(this.charset);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.interval <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid interval %d. Interval must be greater than 0.", this.interval));
        }
        if (this.readTimeout < 0) {
            throw new IllegalArgumentException(String.format("Invalid readTimeout %d. Timeout must be 0 or a positive number.", this.readTimeout));
        }
        try {
            Charset.forName(this.charset);
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException(String.format("Invalid charset %s.", this.charset));
        }
    }

    @Override
    public void validate(FailureCollector collector) {
        if (!this.containsMacro(NAME_INTERVAL) && this.interval <= 0L) {
            collector.addFailure(String.format("Invalid interval '%d'.", this.interval), "Interval must be greater than 0.").withConfigProperty(NAME_INTERVAL);
        }
        if (this.readTimeout < 0) {
            collector.addFailure(String.format("Invalid readTimeout '%d'.", this.readTimeout), "Timeout must be 0 or a positive number.").withConfigProperty(NAME_READ_TIMEOUT);
        }
        try {
            Charset.forName(this.charset);
        }
        catch (UnsupportedCharsetException e) {
            collector.addFailure(String.format("Invalid charset '%s'.", this.charset), "Supported character sets are : ISO-8859-1, US-ASCII, UTF-8, UTF-16, UTF-16BE, UTF-16LE").withConfigProperty(NAME_CHARSET);
        }
    }
}

