/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.http;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.common.http.HTTPPollConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPRequestor {
    public static final Schema SCHEMA = Schema.recordOf((String)"event", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ts", (Schema)Schema.of((Schema.Type)Schema.Type.LONG)), Schema.Field.of((String)"url", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"responseCode", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"headers", (Schema)Schema.mapOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING), (Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"body", (Schema)Schema.of((Schema.Type)Schema.Type.STRING))});
    private final HTTPPollConfig config;

    public HTTPRequestor(HTTPPollConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructuredRecord get() throws IOException {
        int responseCode;
        HttpURLConnection connection;
        String response;
        block30: {
            URL url = new URL(this.config.getUrl());
            response = "";
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(this.config.getConnectTimeout());
            connection.setReadTimeout(this.config.getReadTimeout());
            connection.setInstanceFollowRedirects(this.config.shouldFollowRedirects());
            for (Map.Entry<String, String> requestHeader : this.config.getRequestHeadersMap().entrySet()) {
                connection.setRequestProperty(requestHeader.getKey(), requestHeader.getValue());
            }
            responseCode = connection.getResponseCode();
            try {
                Throwable throwable;
                InputStreamReader reader;
                if (connection.getErrorStream() != null) {
                    reader = new InputStreamReader(connection.getErrorStream(), this.config.getCharset());
                    throwable = null;
                    try {
                        response = CharStreams.toString((Readable)reader);
                        break block30;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Reader)reader).close();
                            }
                        }
                    }
                }
                if (connection.getInputStream() == null) break block30;
                reader = new InputStreamReader(connection.getInputStream(), this.config.getCharset());
                throwable = null;
                try {
                    response = CharStreams.toString((Readable)reader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        Map<String, List<String>> headers = connection.getHeaderFields();
        HashMap<String, String> flattenedHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (Strings.isNullOrEmpty((String)entry.getKey())) continue;
            flattenedHeaders.put(entry.getKey(), Joiner.on((char)',').skipNulls().join((Iterable)entry.getValue()));
        }
        return this.createStructuredRecord(response, flattenedHeaders, responseCode);
    }

    private StructuredRecord createStructuredRecord(String response, Map<String, String> headerFields, int responseCode) {
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)SCHEMA);
        recordBuilder.set("ts", (Object)System.currentTimeMillis()).set("url", (Object)this.config.getUrl()).set("responseCode", (Object)responseCode).set("headers", headerFields).set("body", (Object)response);
        return recordBuilder.build();
    }
}

