/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.script;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.cdap.cdap.etl.api.CacheConfig;
import io.cdap.cdap.etl.api.Lookup;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CachingLookup<T>
implements Lookup<T> {
    private final Lookup<T> delegate;
    private final LoadingCache<String, T> cache;

    public CachingLookup(final Lookup<T> delegate, CacheConfig cacheConfig) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getMaxSize()).expireAfterWrite(cacheConfig.getExpirySeconds(), TimeUnit.SECONDS).build(new CacheLoader<String, T>(){

            public T load(String key) throws Exception {
                return delegate.lookup(key);
            }
        });
    }

    public T lookup(String key) {
        return (T)this.cache.getUnchecked((Object)key);
    }

    public Map<String, T> lookup(String ... keys) {
        return this.lookup((Set<String>)ImmutableSet.copyOf((Object[])keys));
    }

    public Map<String, T> lookup(Set<String> keys) {
        ImmutableMap cached = this.cache.getAllPresent(keys);
        Sets.SetView missingKeys = Sets.difference(keys, (Set)cached.keySet());
        Map missing = this.delegate.lookup((Set)missingKeys);
        this.cache.putAll(missing);
        return ImmutableMap.builder().putAll((Map)cached).putAll(missing).build();
    }
}

