/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.script;

import io.cdap.cdap.etl.api.Arguments;
import io.cdap.cdap.etl.api.LookupConfig;
import io.cdap.cdap.etl.api.LookupProvider;
import io.cdap.cdap.etl.api.StageMetrics;
import io.cdap.plugin.common.script.JavaTypeConverters;
import io.cdap.plugin.common.script.ScriptLookup;
import io.cdap.plugin.common.script.ScriptLookupProvider;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScriptContext {
    private final Logger logger;
    private final StageMetrics metrics;
    private final ScriptLookupProvider lookup;
    private final JavaTypeConverters js;
    private final Arguments arguments;

    public ScriptContext(Logger logger, StageMetrics metrics, LookupProvider lookup, @Nullable LookupConfig lookupConfig, JavaTypeConverters js, Arguments arguments) {
        this.logger = logger;
        this.metrics = metrics;
        this.lookup = new ScriptLookupProvider(lookup, lookupConfig);
        this.js = js;
        this.arguments = arguments;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public StageMetrics getMetrics() {
        return this.metrics;
    }

    public ScriptLookup getLookup(String table) {
        return this.lookup.provide(table, this.js);
    }

    public Arguments getArguments() {
        return this.arguments;
    }
}

