/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.script;

import io.cdap.cdap.api.dataset.DatasetProperties;
import io.cdap.cdap.etl.api.Lookup;
import io.cdap.cdap.etl.api.LookupConfig;
import io.cdap.cdap.etl.api.LookupProvider;
import io.cdap.cdap.etl.api.LookupTableConfig;
import io.cdap.plugin.common.script.JavaTypeConverters;
import io.cdap.plugin.common.script.ScriptLookup;

public class ScriptLookupProvider {
    private final LookupProvider delegate;
    private final LookupConfig config;

    public ScriptLookupProvider(LookupProvider delegate, LookupConfig config) {
        this.delegate = delegate;
        this.config = config;
    }

    public ScriptLookup provide(String table, JavaTypeConverters converters) {
        if (this.config == null) {
            throw new RuntimeException("Missing lookup configuration");
        }
        LookupTableConfig tableConfig = this.config.getTable(table);
        if (tableConfig == null || tableConfig.getType() != LookupTableConfig.TableType.DATASET) {
            throw new RuntimeException(String.format("Dataset %s not declared in configuration", table));
        }
        DatasetProperties arguments = DatasetProperties.builder().addAll(tableConfig.getDatasetProperties()).build();
        return new ScriptLookup((Lookup<Object>)this.delegate.provide(table, arguments.getProperties()), tableConfig, converters);
    }
}

