/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.spark;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class SparkUtils {
    private SparkUtils() {
    }

    public static void validateConfigParameters(Schema inputSchema, @Nullable String featuresToInclude, @Nullable String featuresToExclude, String predictionField, @Nullable String cardinalityMapping) {
        if (!Strings.isNullOrEmpty((String)featuresToExclude) && !Strings.isNullOrEmpty((String)featuresToInclude)) {
            throw new IllegalArgumentException("Cannot specify values for both featuresToInclude and featuresToExclude. Please specify fields for one.");
        }
        Map<String, Integer> fields = SparkUtils.getFeatureList(inputSchema, featuresToInclude, featuresToExclude, predictionField);
        for (String field : fields.keySet()) {
            Schema.Field inputField = inputSchema.getField(field);
            Schema schema = inputField.getSchema();
            Schema.Type features = schema.isNullableSimple() ? schema.getNonNullable().getType() : schema.getType();
            if (features.equals((Object)Schema.Type.INT) || features.equals((Object)Schema.Type.LONG) || features.equals((Object)Schema.Type.FLOAT) || features.equals((Object)Schema.Type.DOUBLE)) continue;
            throw new IllegalArgumentException(String.format("Features must be of type : int, double, float, long but was of type %s for field %s.", features, field));
        }
        SparkUtils.getCategoricalFeatureInfo(inputSchema, featuresToInclude, featuresToExclude, predictionField, cardinalityMapping);
    }

    public static Map<String, Integer> getFeatureList(Schema inputSchema, @Nullable String featuresToInclude, @Nullable String featuresToExclude, String predictionField) {
        if (!Strings.isNullOrEmpty((String)featuresToExclude) && !Strings.isNullOrEmpty((String)featuresToInclude)) {
            throw new IllegalArgumentException("Cannot specify values for both featuresToInclude and featuresToExclude. Please specify fields for one.");
        }
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        if (!Strings.isNullOrEmpty((String)featuresToInclude)) {
            Iterable tokens = Splitter.on((char)',').trimResults().split((CharSequence)featuresToInclude);
            String[] features = (String[])Iterables.toArray((Iterable)tokens, String.class);
            for (int i = 0; i < features.length; ++i) {
                String field = features[i];
                Schema.Field inputField = inputSchema.getField(field);
                if (field.equals(predictionField) || inputField == null) continue;
                fields.put(field, i);
            }
            return fields;
        }
        HashSet excludeFeatures = new HashSet();
        if (!Strings.isNullOrEmpty((String)featuresToExclude)) {
            excludeFeatures.addAll(Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)featuresToExclude)));
        }
        Object[] inputSchemaFields = inputSchema.getFields().toArray();
        for (int i = 0; i < inputSchemaFields.length; ++i) {
            String field = ((Schema.Field)inputSchemaFields[i]).getName();
            if (field.equals(predictionField) || excludeFeatures.contains(field)) continue;
            fields.put(field, i);
        }
        return fields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Integer, Integer> getCategoricalFeatureInfo(Schema inputSchema, @Nullable String featuresToInclude, @Nullable String featuresToExclude, String labelField, @Nullable String cardinalityMapping) {
        Map<String, Integer> featureList = SparkUtils.getFeatureList(inputSchema, featuresToInclude, featuresToExclude, labelField);
        HashMap<Integer, Integer> outputFieldMappings = new HashMap<Integer, Integer>();
        if (Strings.isNullOrEmpty((String)cardinalityMapping)) {
            return outputFieldMappings;
        }
        try {
            Map map = Splitter.on((char)',').trimResults().withKeyValueSeparator(":").split((CharSequence)cardinalityMapping);
            for (Map.Entry field : map.entrySet()) {
                String value = (String)field.getValue();
                try {
                    outputFieldMappings.put(featureList.get(field.getKey()), Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid cardinality %s. Please specify valid integer for cardinality.", value));
                    return outputFieldMappings;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid categorical feature mapping. %s. Please make sure it is in the format 'feature':'cardinality'.", e.getMessage()), e);
        }
    }

    public static void validateLabelFieldForTrainer(Schema inputSchema, String labelField) {
        Schema.Type predictionFieldType;
        Schema.Field prediction = inputSchema.getField(labelField);
        if (prediction == null) {
            throw new IllegalArgumentException(String.format("Label field %s does not exists in the input schema.", labelField));
        }
        Schema predictionSchema = prediction.getSchema();
        Schema.Type type = predictionFieldType = predictionSchema.isNullableSimple() ? predictionSchema.getNonNullable().getType() : predictionSchema.getType();
        if (predictionFieldType != Schema.Type.DOUBLE) {
            throw new IllegalArgumentException(String.format("Label field must be of type Double, but was %s.", predictionFieldType));
        }
    }

    public static StructuredRecord.Builder cloneRecord(StructuredRecord record, Schema outputSchema, String predictionField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(outputSchema.getFields());
        fields.add(Schema.Field.of((String)predictionField, (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)));
        outputSchema = Schema.recordOf((String)"records", fields);
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)outputSchema);
        for (Schema.Field field : outputSchema.getFields()) {
            if (predictionField.equals(field.getName())) continue;
            builder.set(field.getName(), record.get(field.getName()));
        }
        return builder;
    }

    public static Schema getOutputSchema(Schema inputSchema, String predictionField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(inputSchema.getFields());
        fields.add(Schema.Field.of((String)predictionField, (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)));
        return Schema.recordOf((String)(inputSchema.getRecordName() + ".predicted"), fields);
    }

    public static void validateFeatureGeneratorConfig(Schema inputSchema, Map<String, String> map, String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid expression - %s. Please provide a valid pattern for splitting the string. %s.", pattern, e.getMessage()), e);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SparkUtils.validateTextField(inputSchema, key);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Output column name not specified for column : %s. Please make sure it is in the format 'input-column':'transformed-output-column'.", entry.getKey()));
            }
            if (inputSchema.getField(value) == null) continue;
            throw new IllegalArgumentException(String.format("Output column name %s for column %s is already present in the input schema. Please provide a different output field name.", value, key));
        }
    }

    public static void validateTextField(Schema inputSchema, String key) {
        Schema.Type type;
        if (inputSchema.getField(key) == null) {
            throw new IllegalArgumentException(String.format("Input field %s does not exist in the input schema %s.", key, inputSchema.toString()));
        }
        Schema schema = inputSchema.getField(key).getSchema();
        Schema.Type type2 = type = schema.isNullable() ? schema.getNonNullable().getType() : schema.getType();
        if (type == Schema.Type.ARRAY) {
            Schema componentSchema = schema.getComponentSchema();
            Schema.Type type3 = type = componentSchema.isNullable() ? componentSchema.getNonNullable().getType() : componentSchema.getType();
        }
        if (type != Schema.Type.STRING) {
            throw new IllegalArgumentException(String.format("Field to be transformed should be of type String or Nullable String or Array of type String or Nullable String . But was %s for field %s.", type, key));
        }
    }

    public static List<String> getInputFieldValue(StructuredRecord input, String inputField, Splitter splitter) {
        List text = new ArrayList<String>();
        Schema schema = input.getSchema().getField(inputField).getSchema();
        Schema.Type type = schema.isNullable() ? schema.getNonNullable().getType() : schema.getType();
        try {
            if (type == Schema.Type.ARRAY) {
                Object value = input.get(inputField);
                text = value instanceof List ? (List)input.get(inputField) : Lists.newArrayList((Object[])((String[])value));
            } else {
                String value = (String)input.get(inputField);
                if (value != null) {
                    text = Lists.newArrayList((Iterable)splitter.split((CharSequence)value));
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Schema type mismatch for field %s. Please make sure the value to be used for feature generation is an array of string or a string.", inputField), e);
        }
        return text;
    }
}

