/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common.spark;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.spark.mllib.linalg.SparseVector;

public class VectorUtils {
    public static final Schema SPARSE_SCHEMA = Schema.recordOf((String)"sparseVector", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"size", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"indices", (Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"vectorValues", (Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)))});

    public static StructuredRecord asRecord(SparseVector vector) {
        return StructuredRecord.builder((Schema)SPARSE_SCHEMA).set("size", (Object)vector.size()).set("indices", (Object)vector.indices()).set("vectorValues", (Object)vector.values()).build();
    }

    public static SparseVector fromRecord(StructuredRecord record) {
        double[] values;
        int[] indices;
        int size = (Integer)record.get("size");
        Object index = record.get("indices");
        if (index instanceof List) {
            List indexList = (List)index;
            indices = ArrayUtils.toPrimitive((Integer[])indexList.toArray(new Integer[indexList.size()]));
        } else {
            indices = (int[])index;
        }
        Object value = record.get("vectorValues");
        if (value instanceof List) {
            List doubleList = (List)value;
            values = ArrayUtils.toPrimitive((Double[])doubleList.toArray(new Double[doubleList.size()]));
        } else {
            values = (double[])value;
        }
        return new SparseVector(size, indices, values);
    }
}

