/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.google.common.base.Preconditions;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.plugin.salesforce.SObjectsDescribeResult;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.SalesforceFunctionType;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.parser.SalesforceQueryParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SObjectDescriptor {
    private final String name;
    private final List<FieldDescriptor> fields;
    private final List<SObjectDescriptor> childSObjects;

    public static SObjectDescriptor fromName(String name, AuthenticatorCredentials credentials, Set<FieldType> typesToSkip) throws ConnectionException {
        PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(credentials);
        SObjectsDescribeResult describeResult = SObjectsDescribeResult.of(partnerConnection, Collections.singletonList(name));
        List<FieldDescriptor> fields = describeResult.getFields().stream().filter(field -> !typesToSkip.contains(field.getType())).map(FieldDescriptor::new).collect(Collectors.toList());
        return new SObjectDescriptor(name, fields);
    }

    public static SObjectDescriptor fromName(String name, AuthenticatorCredentials credentials) throws ConnectionException {
        return SObjectDescriptor.fromName(name, credentials, Collections.emptySet());
    }

    public static SObjectDescriptor fromQuery(String query) {
        return SalesforceQueryParser.getObjectDescriptorFromQuery(query);
    }

    public SObjectDescriptor(String name, List<FieldDescriptor> fields) {
        this(name, fields, Collections.emptyList());
    }

    public SObjectDescriptor(String name, List<FieldDescriptor> fields, List<SObjectDescriptor> childSObjects) {
        this.name = name;
        this.fields = new ArrayList<FieldDescriptor>(fields);
        this.childSObjects = childSObjects;
    }

    public String getName() {
        return this.name;
    }

    public Set<FeaturedSObjects> getFeaturedSObjects() {
        Set<FeaturedSObjects> result = this.getFeaturedSObjects(null, this.getFields());
        for (SObjectDescriptor child : this.getChildSObjects()) {
            result.add(new FeaturedSObjects(child.getName(), Collections.emptyList()));
            result.addAll(this.getFeaturedSObjects(child.getName(), child.getFields()));
        }
        return result;
    }

    private Set<FeaturedSObjects> getFeaturedSObjects(String name, List<FieldDescriptor> fields) {
        return fields.stream().filter(FieldDescriptor::hasParents).map(f -> new FeaturedSObjects(name, f.getParents())).collect(Collectors.toSet());
    }

    public List<String> getFieldsNames() {
        return this.fields.stream().map(FieldDescriptor::getQueryName).collect(Collectors.toList());
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<SObjectDescriptor> getChildSObjects() {
        return this.childSObjects;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.childSObjects);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SObjectDescriptor that = (SObjectDescriptor)o;
        return this.name.equals(that.name) && this.fields.equals(that.fields) && this.childSObjects.equals(that.childSObjects);
    }

    public String toString() {
        return "SObjectDescriptor{name=" + this.name + ", fields=" + this.fields + ", childSObjects=" + this.childSObjects + '}';
    }

    public static class FeaturedSObjects {
        @Nullable
        private final String relationship;
        private final List<String> references;

        public FeaturedSObjects(String relationship, List<String> references) {
            this.relationship = relationship;
            this.references = references == null ? Collections.emptyList() : references;
        }

        public String getRelationship() {
            return this.relationship;
        }

        public List<String> getReferences() {
            return this.references;
        }

        public boolean hasRelationship() {
            return this.relationship != null;
        }

        public boolean hasReferences() {
            return !this.references.isEmpty();
        }

        public String getFullName(String topLevelName) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(topLevelName);
            if (this.hasRelationship()) {
                names.add(this.relationship);
            }
            if (this.hasReferences()) {
                names.addAll(this.references);
            }
            return String.join((CharSequence)".", names);
        }

        public int hashCode() {
            return Objects.hash(this.relationship, this.references);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeaturedSObjects obj = (FeaturedSObjects)o;
            return Objects.equals(this.relationship, obj.relationship) && Objects.equals(this.references, obj.references);
        }

        public String toString() {
            return "FeaturedSObjects{relationship=" + this.relationship + ", references=" + this.references + '}';
        }
    }

    public static class FieldDescriptor {
        private final Field field;
        private final List<String> parents;
        @Nullable
        private final String alias;
        private final SalesforceFunctionType functionType;

        public FieldDescriptor(Field field) {
            this.field = field;
            this.parents = new ArrayList<String>();
            this.alias = null;
            this.functionType = SalesforceFunctionType.NONE;
        }

        public FieldDescriptor(List<String> nameParts, String alias, SalesforceFunctionType functionType) {
            Preconditions.checkState((nameParts != null && !nameParts.isEmpty() ? 1 : 0) != 0, (Object)"Given list of name parts must contain at least one element");
            this.parents = new ArrayList<String>(nameParts);
            this.field = new Field();
            this.field.setName(this.parents.remove(nameParts.size() - 1));
            this.alias = alias;
            this.functionType = functionType;
        }

        public String getName() {
            return this.field.getName();
        }

        public String getFullName() {
            if (this.hasParents()) {
                ArrayList<String> nameParts = new ArrayList<String>(this.parents);
                nameParts.add(this.field.getName());
                return String.join((CharSequence)".", nameParts);
            }
            return this.field.getName();
        }

        public boolean hasParents() {
            return !this.parents.isEmpty();
        }

        public List<String> getParents() {
            return this.parents;
        }

        public String getParentsPath(List<String> topLevelParents) {
            ArrayList<String> allParents = new ArrayList<String>(topLevelParents);
            allParents.addAll(this.parents);
            return String.join((CharSequence)".", allParents);
        }

        @Nullable
        public FieldType getFieldType() {
            return this.field.getType();
        }

        public List<String> getNameParts() {
            ArrayList<String> nameParts = new ArrayList<String>(this.parents);
            nameParts.add(this.field.getName());
            return nameParts;
        }

        public boolean hasAlias() {
            return this.alias != null;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getQueryName() {
            return this.hasAlias() ? this.alias : this.getFullName();
        }

        public SalesforceFunctionType getFunctionType() {
            return this.functionType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.field.getName(), this.field.getType(), this.field.isNillable(), this.parents, this.alias, this.functionType});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldDescriptor that = (FieldDescriptor)o;
            return Objects.equals(this.field.getName(), that.field.getName()) && this.field.getType() == that.field.getType() && this.field.isNillable() == that.field.isNillable() && this.parents.equals(that.parents) && Objects.equals(this.alias, that.alias) && this.functionType == that.functionType;
        }

        public String toString() {
            return "FieldDescriptor{fieldName=" + this.field.getName() + ", fieldType=" + this.field.getType() + ", nillable=" + this.field.isNillable() + ", parents=" + this.parents + ", alias=" + this.alias + ", functionType=" + (Object)((Object)this.functionType) + '}';
        }
    }
}

