/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SObjectFilterDescriptor {
    private static final SObjectFilterDescriptor NO_OP_FILTER_INSTANCE = new SObjectFilterDescriptor(null, null);
    @Nullable
    private final ZonedDateTime startTime;
    @Nullable
    private final ZonedDateTime endTime;

    public static SObjectFilterDescriptor noOp() {
        return NO_OP_FILTER_INSTANCE;
    }

    public static SObjectFilterDescriptor interval(@Nullable ZonedDateTime startTime, @Nullable ZonedDateTime endTime) {
        return startTime == null && endTime == null ? NO_OP_FILTER_INSTANCE : new SObjectFilterDescriptor(startTime, endTime);
    }

    public static SObjectFilterDescriptor range(long logicalStartTime, Map<ChronoUnit, Integer> duration, Map<ChronoUnit, Integer> offset) {
        return SObjectFilterDescriptor.calculateRangeFilter(SObjectFilterDescriptor.toZonedDateTime(logicalStartTime), duration, offset);
    }

    private SObjectFilterDescriptor(@Nullable ZonedDateTime startTime, @Nullable ZonedDateTime endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Nullable
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public boolean isNoOp() {
        return this.equals(NO_OP_FILTER_INSTANCE);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SObjectFilterDescriptor that = (SObjectFilterDescriptor)o;
        return Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime);
    }

    public String toString() {
        return "SObjectFilterDescriptor{startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }

    private static SObjectFilterDescriptor calculateRangeFilter(ZonedDateTime logicalStartTime, Map<ChronoUnit, Integer> duration, Map<ChronoUnit, Integer> offset) {
        if (duration.isEmpty() && offset.isEmpty()) {
            return NO_OP_FILTER_INSTANCE;
        }
        ZonedDateTime endTime = logicalStartTime;
        for (Map.Entry<ChronoUnit, Integer> entry : offset.entrySet()) {
            endTime = endTime.minus(entry.getValue().intValue(), entry.getKey());
        }
        ZonedDateTime startTime = endTime;
        for (Map.Entry<ChronoUnit, Integer> entry : duration.entrySet()) {
            startTime = startTime.minus(entry.getValue().intValue(), entry.getKey());
        }
        if (startTime.equals(endTime) && endTime.equals(logicalStartTime)) {
            return NO_OP_FILTER_INSTANCE;
        }
        return new SObjectFilterDescriptor(startTime.equals(endTime) ? null : startTime, endTime);
    }

    private static ZonedDateTime toZonedDateTime(long timeInMillis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneOffset.UTC);
    }
}

