/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.google.common.collect.Lists;
import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SObjectsDescribeResult {
    private static final int DESCRIBE_SOBJECTS_LIMIT = 100;
    private final Map<String, Map<String, Field>> objectToFieldMap;

    public static SObjectsDescribeResult of(PartnerConnection connection, Collection<String> sObjects) throws ConnectionException {
        HashMap<String, Map<String, Field>> objectToFieldMap = new HashMap<String, Map<String, Field>>();
        for (List partition : Lists.partition(new ArrayList<String>(sObjects), (int)100)) {
            DescribeSObjectResult[] describeSObjectResults = connection.describeSObjects(partition.toArray(new String[0]));
            Stream.of(describeSObjectResults).forEach(result -> SObjectsDescribeResult.addSObjectDescribe(result.getName(), result.getFields(), objectToFieldMap));
        }
        return new SObjectsDescribeResult(objectToFieldMap);
    }

    public static SObjectsDescribeResult of(PartnerConnection connection, String name, Collection<SObjectDescriptor.FeaturedSObjects> featuredSObjectsCombinations) throws ConnectionException {
        HashMap<String, Map<String, Field>> objectToFieldMap = new HashMap<String, Map<String, Field>>();
        HashMap<String, DescribeSObjectResult> cache = new HashMap<String, DescribeSObjectResult>();
        DescribeSObjectResult topLevelDescribe = SObjectsDescribeResult.describe(connection, name, cache);
        SObjectsDescribeResult.addSObjectDescribe(name, topLevelDescribe.getFields(), objectToFieldMap);
        for (SObjectDescriptor.FeaturedSObjects featuredSObjects : featuredSObjectsCombinations) {
            DescribeSObjectResult lastDescribe = topLevelDescribe;
            if (featuredSObjects.hasRelationship()) {
                String relationshipName = SObjectsDescribeResult.getRelationshipName(featuredSObjects.getRelationship(), lastDescribe);
                if (relationshipName == null) {
                    throw new IllegalArgumentException(String.format("Relationship field name '%s' is absent in SObject '%s' describe result", featuredSObjects.getRelationship(), lastDescribe.getName()));
                }
                lastDescribe = SObjectsDescribeResult.describe(connection, relationshipName, cache);
            }
            if (featuredSObjects.hasReferences()) {
                for (String reference : featuredSObjects.getReferences()) {
                    String referenceName = SObjectsDescribeResult.getReferenceName(reference, lastDescribe);
                    if (referenceName == null) {
                        throw new IllegalArgumentException(String.format("Reference field name '%s' is absent in SObject '%s' describe result", reference, lastDescribe.getName()));
                    }
                    lastDescribe = SObjectsDescribeResult.describe(connection, referenceName, cache);
                }
            }
            SObjectsDescribeResult.addSObjectDescribe(featuredSObjects.getFullName(name), lastDescribe.getFields(), objectToFieldMap);
        }
        return new SObjectsDescribeResult(objectToFieldMap);
    }

    public static SObjectsDescribeResult of(Map<String, Map<String, Field>> holder) {
        HashMap<String, Map<String, Field>> objectToFieldMap = new HashMap<String, Map<String, Field>>();
        for (Map.Entry<String, Map<String, Field>> holderEntry : holder.entrySet()) {
            String sObjectName = holderEntry.getKey();
            Map<String, Field> fieldsMap = holderEntry.getValue();
            LinkedHashMap fieldsMapLowerCase = new LinkedHashMap();
            fieldsMap.forEach((key, value) -> fieldsMapLowerCase.put(key.toLowerCase(), value));
            objectToFieldMap.put(sObjectName.toLowerCase(), fieldsMapLowerCase);
        }
        return new SObjectsDescribeResult(objectToFieldMap);
    }

    private SObjectsDescribeResult(Map<String, Map<String, Field>> objectToFieldMap) {
        this.objectToFieldMap = objectToFieldMap;
    }

    public List<Field> getFields() {
        return this.objectToFieldMap.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Field getField(String sObjectName, String fieldName) {
        Map<String, Field> fields = this.objectToFieldMap.get(sObjectName.toLowerCase());
        return fields == null ? null : fields.get(fieldName.toLowerCase());
    }

    private static void addSObjectDescribe(String name, Field[] result, Map<String, Map<String, Field>> objectToFieldMap) {
        Map fields = Arrays.stream(result).collect(Collectors.toMap(field -> field.getName().toLowerCase(), Function.identity(), (o, n) -> n, LinkedHashMap::new));
        objectToFieldMap.put(name.toLowerCase(), fields);
    }

    private static String getReferenceName(String name, DescribeSObjectResult result) {
        return result == null ? null : (String)Stream.of(result.getFields()).filter(field -> name.equals(field.getRelationshipName())).findAny().map(field -> field.getReferenceTo()[0]).orElse(null);
    }

    private static String getRelationshipName(String name, DescribeSObjectResult result) {
        return result == null ? null : (String)Stream.of(result.getChildRelationships()).filter(childRelationship -> name.equals(childRelationship.getRelationshipName())).findAny().map(ChildRelationship::getChildSObject).orElse(null);
    }

    private static DescribeSObjectResult describe(PartnerConnection connection, String name, Map<String, DescribeSObjectResult> cache) throws ConnectionException {
        DescribeSObjectResult describe = cache.get(name.toLowerCase());
        if (describe == null && (describe = connection.describeSObject(name)) == null) {
            throw new IllegalArgumentException("Unable to describe SObject: " + name);
        }
        cache.put(name.toLowerCase(), describe);
        return describe;
    }

    public static boolean isCustomObject(PartnerConnection connection, String name) throws ConnectionException {
        return SObjectsDescribeResult.describe(connection, name, new HashMap<String, DescribeSObjectResult>()).isCustom();
    }
}

