/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.google.common.base.Preconditions;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.CSVReader;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import io.cdap.plugin.salesforce.BulkAPIBatchException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SalesforceBulkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceBulkUtil.class);

    public static JobInfo createJob(BulkConnection bulkConnection, String sObject, OperationEnum operationEnum, @Nullable String externalIdField) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setObject(sObject);
        job.setOperation(operationEnum);
        job.setConcurrencyMode(ConcurrencyMode.Parallel);
        job.setContentType(ContentType.CSV);
        if (externalIdField != null) {
            job.setExternalIdFieldName(externalIdField);
        }
        Preconditions.checkState(((job = bulkConnection.createJob(job)).getId() != null ? 1 : 0) != 0, (Object)"Couldn't get job ID. There was a problem in creating the batch job");
        return bulkConnection.getJobStatus(job.getId());
    }

    public static void closeJob(BulkConnection bulkConnection, String jobId) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setId(jobId);
        job.setState(JobStateEnum.Closed);
        bulkConnection.updateJob(job);
    }

    public static void checkResults(BulkConnection bulkConnection, JobInfo job, List<BatchInfo> batchInfoList, boolean ignoreFailures) throws AsyncApiException, IOException {
        for (BatchInfo batchInfo : batchInfoList) {
            ArrayList row;
            CSVReader rdr = new CSVReader(bulkConnection.getBatchResultStream(job.getId(), batchInfo.getId()));
            ArrayList resultHeader = rdr.nextRecord();
            int resultCols = resultHeader.size();
            while ((row = rdr.nextRecord()) != null) {
                HashMap resultInfo = new HashMap();
                for (int i = 0; i < resultCols; ++i) {
                    resultInfo.put(resultHeader.get(i), row.get(i));
                }
                boolean success = Boolean.parseBoolean((String)resultInfo.get("Success"));
                if (success) continue;
                String error = (String)resultInfo.get("Error");
                String errorMessage = String.format("Failed to create row with error: '%s'. BatchId='%s'", error, batchInfo.getId());
                if (ignoreFailures) {
                    LOG.error(errorMessage);
                    continue;
                }
                throw new RuntimeException(errorMessage);
            }
        }
    }

    public static void awaitCompletion(BulkConnection bulkConnection, JobInfo job, List<BatchInfo> batchInfoList) {
        Set incomplete = batchInfoList.stream().map(BatchInfo::getId).collect(Collectors.toSet());
        Awaitility.await().atMost(600L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> {
            BatchInfo[] statusList;
            for (BatchInfo b : statusList = bulkConnection.getBatchInfoList(job.getId()).getBatchInfo()) {
                if (b.getState() == BatchStateEnum.Failed) {
                    throw new BulkAPIBatchException("Batch failed", b);
                }
                if (b.getState() != BatchStateEnum.Completed) continue;
                incomplete.remove(b.getId());
            }
            return incomplete.isEmpty();
        });
    }
}

