/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import org.apache.hadoop.conf.Configuration;

public class SalesforceConnectionUtil {
    public static PartnerConnection getPartnerConnection(AuthenticatorCredentials credentials) throws ConnectionException {
        ConnectorConfig connectorConfig = Authenticator.createConnectorConfig(credentials);
        return new PartnerConnection(connectorConfig);
    }

    public static AuthenticatorCredentials getAuthenticatorCredentials(Configuration conf) {
        String oAuthToken = conf.get("mapred.salesforce.oauth.token");
        String instanceURL = conf.get("mapred.salesforce.oauth.instance.url");
        if (oAuthToken != null && instanceURL != null) {
            return new AuthenticatorCredentials(new OAuthInfo(oAuthToken, instanceURL));
        }
        return new AuthenticatorCredentials(conf.get("mapred.salesforce.user"), conf.get("mapred.salesforce.password"), conf.get("mapred.salesforce.consumer.key"), conf.get("mapred.salesforce.consumer.secret"), conf.get("mapred.salesforce.login.url"));
    }
}

