/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.data.schema.Schema;
import java.util.Map;

public enum SalesforceFunctionType {
    IDENTITY(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return fieldSchema;
        }
    }
    ,
    NUMERIC(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            Schema.Type type = fieldSchema.isNullable() ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
            switch (type) {
                case INT: 
                case LONG: {
                    return SalesforceFunctionType.addNullability(Schema.of((Schema.Type)Schema.Type.LONG), fieldSchema.isNullable());
                }
                case DOUBLE: {
                    return SalesforceFunctionType.addNullability(Schema.of((Schema.Type)Schema.Type.DOUBLE), fieldSchema.isNullable());
                }
            }
            throw new IllegalArgumentException("Non numeric field schema type: " + type);
        }
    }
    ,
    DOUBLE(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return SalesforceFunctionType.addNullability(Schema.of((Schema.Type)Schema.Type.DOUBLE), fieldSchema.isNullable());
        }
    }
    ,
    LONG_REQUIRED(true){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return Schema.of((Schema.Type)Schema.Type.LONG);
        }
    }
    ,
    INT_REQUIRED(true){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return Schema.of((Schema.Type)Schema.Type.INT);
        }
    }
    ,
    INT(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return SalesforceFunctionType.addNullability(Schema.of((Schema.Type)Schema.Type.INT), fieldSchema.isNullable());
        }
    }
    ,
    DATE(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return SalesforceFunctionType.addNullability(Schema.of((Schema.LogicalType)Schema.LogicalType.DATE), fieldSchema.isNullable());
        }
    }
    ,
    UNKNOWN(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return fieldSchema;
        }
    }
    ,
    NONE(false){

        @Override
        public Schema getSchema(Schema fieldSchema) {
            return fieldSchema;
        }
    };

    private boolean constant;
    private static final Map<String, SalesforceFunctionType> SALESFORCE_FUNCTIONS_TYPE_MAPPING;

    private SalesforceFunctionType(boolean constant) {
        this.constant = constant;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public abstract Schema getSchema(Schema var1);

    private static Schema addNullability(Schema functionSchema, boolean nullable) {
        return nullable ? Schema.nullableOf((Schema)functionSchema) : functionSchema;
    }

    public static SalesforceFunctionType get(String functionName) {
        return SALESFORCE_FUNCTIONS_TYPE_MAPPING.getOrDefault(((String)Preconditions.checkNotNull((Object)functionName, (Object)"Function name can not be null")).toUpperCase(), UNKNOWN);
    }

    static {
        SALESFORCE_FUNCTIONS_TYPE_MAPPING = new ImmutableMap.Builder().put((Object)"MIN", (Object)IDENTITY).put((Object)"MAX", (Object)IDENTITY).put((Object)"SUM", (Object)NUMERIC).put((Object)"AVG", (Object)DOUBLE).put((Object)"COUNT", (Object)LONG_REQUIRED).put((Object)"COUNT_DISTINCT", (Object)LONG_REQUIRED).put((Object)"GROUPING", (Object)INT_REQUIRED).put((Object)"CALENDAR_MONTH", (Object)INT).put((Object)"CALENDAR_QUARTER", (Object)INT).put((Object)"CALENDAR_YEAR", (Object)INT).put((Object)"DAY_IN_MONTH", (Object)INT).put((Object)"DAY_IN_WEEK", (Object)INT).put((Object)"DAY_IN_YEAR", (Object)INT).put((Object)"FISCAL_MONTH", (Object)INT).put((Object)"FISCAL_QUARTER", (Object)INT).put((Object)"FISCAL_YEAR", (Object)INT).put((Object)"HOUR_IN_DAY", (Object)INT).put((Object)"WEEK_IN_MONTH", (Object)INT).put((Object)"WEEK_IN_YEAR", (Object)INT).put((Object)"DAY_ONLY", (Object)DATE).build();
    }
}

