/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import io.cdap.plugin.salesforce.SObjectFilterDescriptor;
import io.cdap.plugin.salesforce.parser.SalesforceQueryParser;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class SalesforceQueryUtil {
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static final String WHERE = " WHERE ";
    private static final String AND = " AND ";
    private static final String FIELD_LAST_MODIFIED_DATE = "LastModifiedDate";
    private static final String FIELD_ID = "Id";

    public static String createSObjectQuery(List<String> fields, String sObjectName, SObjectFilterDescriptor filterDescriptor) {
        StringBuilder query = new StringBuilder().append(SELECT).append(String.join((CharSequence)",", fields)).append(FROM).append(sObjectName);
        if (!filterDescriptor.isNoOp()) {
            query.append(WHERE).append(SalesforceQueryUtil.generateSObjectFilter(filterDescriptor));
        }
        return query.toString();
    }

    public static boolean isQueryUnderLengthLimit(String query) {
        return query.length() < 20000;
    }

    public static String createSObjectIdQuery(String query) {
        String fromStatement = SalesforceQueryParser.getFromStatement(query);
        return "SELECT Id " + fromStatement;
    }

    private static String generateSObjectFilter(SObjectFilterDescriptor filterDescriptor) {
        StringBuilder filter = new StringBuilder();
        if (filterDescriptor.getStartTime() != null) {
            filter.append(FIELD_LAST_MODIFIED_DATE).append(GREATER_THAN_OR_EQUAL).append(filterDescriptor.getStartTime().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        if (filterDescriptor.getEndTime() != null) {
            if (filter.length() > 0) {
                filter.append(AND);
            }
            filter.append(FIELD_LAST_MODIFIED_DATE).append(LESS_THAN).append(filterDescriptor.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        return filter.toString();
    }
}

