/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectsDescribeResult;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.SalesforceFunctionType;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SalesforceSchemaUtil {
    public static final Set<FieldType> COMPOUND_FIELDS = ImmutableSet.of((Object)FieldType.address, (Object)FieldType.location);
    private static final Map<FieldType, Schema> SALESFORCE_TYPE_TO_CDAP_SCHEMA = new ImmutableMap.Builder().put((Object)FieldType._boolean, (Object)Schema.of((Schema.Type)Schema.Type.BOOLEAN)).put((Object)FieldType._int, (Object)Schema.of((Schema.Type)Schema.Type.INT)).put((Object)FieldType._long, (Object)Schema.of((Schema.Type)Schema.Type.LONG)).put((Object)FieldType._double, (Object)Schema.of((Schema.Type)Schema.Type.DOUBLE)).put((Object)FieldType.currency, (Object)Schema.of((Schema.Type)Schema.Type.DOUBLE)).put((Object)FieldType.percent, (Object)Schema.of((Schema.Type)Schema.Type.DOUBLE)).put((Object)FieldType.date, (Object)Schema.of((Schema.LogicalType)Schema.LogicalType.DATE)).put((Object)FieldType.datetime, (Object)Schema.of((Schema.LogicalType)Schema.LogicalType.TIMESTAMP_MICROS)).put((Object)FieldType.time, (Object)Schema.of((Schema.LogicalType)Schema.LogicalType.TIME_MICROS)).put((Object)FieldType.string, (Object)Schema.of((Schema.Type)Schema.Type.STRING)).put((Object)FieldType.complexvalue, (Object)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))).build();
    private static final Set<Schema.Type> SUPPORTED_TYPES = (Set)SALESFORCE_TYPE_TO_CDAP_SCHEMA.values().stream().map(Schema::getType).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    private static final Set<Schema.LogicalType> SUPPORTED_LOGICAL_TYPES = (Set)SALESFORCE_TYPE_TO_CDAP_SCHEMA.values().stream().map(Schema::getLogicalType).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    private static final Schema DEFAULT_SCHEMA = Schema.of((Schema.Type)Schema.Type.STRING);
    private static final Pattern AVRO_NAME_START_PATTERN = Pattern.compile("^[A-Za-z_]");
    private static final Pattern AVRO_NAME_REPLACE_PATTERN = Pattern.compile("[^A-Za-z0-9_]");

    public static String normalizeAvroName(String name) {
        String finalName = name;
        if (!AVRO_NAME_START_PATTERN.matcher(name).find()) {
            finalName = "A" + finalName;
        }
        return AVRO_NAME_REPLACE_PATTERN.matcher(finalName).replaceAll("_");
    }

    public static Schema getSchema(AuthenticatorCredentials credentials, SObjectDescriptor sObjectDescriptor) throws ConnectionException {
        PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(credentials);
        SObjectsDescribeResult describeResult = SObjectsDescribeResult.of(partnerConnection, sObjectDescriptor.getName(), sObjectDescriptor.getFeaturedSObjects());
        return SalesforceSchemaUtil.getSchemaWithFields(sObjectDescriptor, describeResult);
    }

    public static void validateFieldSchemas(Schema schema, FailureCollector collector) {
        for (Schema.Field field : Objects.requireNonNull(schema.getFields(), "Schema must have fields")) {
            Schema.LogicalType logicalType;
            Schema fieldSchema = field.getSchema();
            Schema schema2 = fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
            if (!SUPPORTED_TYPES.contains(fieldSchema.getType())) {
                collector.addFailure(String.format("Field '%s' is of unsupported type '%s'.", field.getName(), fieldSchema.getDisplayName()), String.format("Supported types are: '%s'", SUPPORTED_TYPES.stream().map(Enum::name).collect(Collectors.joining(", ")))).withOutputSchemaField(field.getName()).withInputSchemaField(field.getName());
            }
            if ((logicalType = fieldSchema.getLogicalType()) == null || SUPPORTED_LOGICAL_TYPES.contains(logicalType)) continue;
            collector.addFailure(String.format("Field '%s' is of unsupported type '%s'.", field.getName(), fieldSchema.getDisplayName()), String.format("Supported types are: '%s'", SUPPORTED_LOGICAL_TYPES.stream().map(Enum::name).collect(Collectors.joining(", ")))).withOutputSchemaField(field.getName()).withInputSchemaField(field.getName());
        }
    }

    public static void checkCompatibility(Schema actualSchema, Schema providedSchema) {
        SalesforceSchemaUtil.checkCompatibility(actualSchema, providedSchema, true);
    }

    public static void checkCompatibility(Schema actualSchema, Schema providedSchema, boolean checkNullable) {
        for (Schema.Field providedField : Objects.requireNonNull(providedSchema.getFields())) {
            Schema.Field actualField = actualSchema.getField(providedField.getName(), true);
            if (actualField == null) {
                throw new IllegalArgumentException(String.format("Field '%s' does not exist in Salesforce", providedField.getName()));
            }
            Schema providedFieldSchema = providedField.getSchema();
            Schema actualFieldSchema = actualField.getSchema();
            boolean isActualFieldNullable = actualFieldSchema.isNullable();
            boolean isProvidedFieldNullable = providedFieldSchema.isNullable();
            actualFieldSchema = isActualFieldNullable ? actualFieldSchema.getNonNullable() : actualFieldSchema;
            Schema schema = providedFieldSchema = isProvidedFieldNullable ? providedFieldSchema.getNonNullable() : providedFieldSchema;
            if (!actualFieldSchema.equals((Object)providedFieldSchema) || !Objects.equals(actualFieldSchema.getLogicalType(), providedFieldSchema.getLogicalType())) {
                throw new IllegalArgumentException(String.format("Expected field '%s' to be of '%s', but it is of '%s'", providedField.getName(), providedFieldSchema, actualFieldSchema));
            }
            if (!checkNullable || !isActualFieldNullable || isProvidedFieldNullable) continue;
            throw new IllegalArgumentException(String.format("Field '%s' should be nullable", providedField.getName()));
        }
    }

    public static Schema getSchemaWithFields(SObjectDescriptor sObjectDescriptor, SObjectsDescribeResult describeResult) {
        return SalesforceSchemaUtil.getSchemaWithFields(sObjectDescriptor, describeResult, Collections.emptyList());
    }

    public static Schema getSchemaWithFields(SObjectDescriptor sObjectDescriptor, SObjectsDescribeResult describeResult, List<String> topLevelParents) {
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
        for (SObjectDescriptor.FieldDescriptor fieldDescriptor : sObjectDescriptor.getFields()) {
            SalesforceFunctionType functionType = fieldDescriptor.getFunctionType();
            Schema fieldSchema = null;
            if (!functionType.isConstant()) {
                ArrayList<String> allTopLevelParents = new ArrayList<String>(topLevelParents);
                allTopLevelParents.add(sObjectDescriptor.getName());
                String parentsPath = fieldDescriptor.getParentsPath(allTopLevelParents);
                Field field = describeResult.getField(parentsPath, fieldDescriptor.getName());
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Field '%s' does not exist in Salesforce object '%s'.", fieldDescriptor.getFullName(), parentsPath));
                }
                fieldSchema = SalesforceSchemaUtil.createFieldSchema(field);
            }
            Schema queryFieldSchema = functionType.getSchema(fieldSchema);
            Schema.Field schemaField = Schema.Field.of((String)SalesforceSchemaUtil.normalizeAvroName(fieldDescriptor.getQueryName()), (Schema)queryFieldSchema);
            schemaFields.add(schemaField);
        }
        for (SObjectDescriptor childSObject : sObjectDescriptor.getChildSObjects()) {
            Schema childSchema = SalesforceSchemaUtil.getSchemaWithFields(childSObject, describeResult, Collections.singletonList(sObjectDescriptor.getName()));
            String childName = SalesforceSchemaUtil.normalizeAvroName(childSObject.getName());
            Schema.Field childField = Schema.Field.of((String)childName, (Schema)Schema.arrayOf((Schema)Schema.recordOf((String)childName, (Iterable)Objects.requireNonNull(childSchema.getFields()))));
            schemaFields.add(childField);
        }
        return Schema.recordOf((String)"output", schemaFields);
    }

    private static Schema createFieldSchema(Field field) {
        Schema fieldSchema = SALESFORCE_TYPE_TO_CDAP_SCHEMA.getOrDefault(field.getType(), DEFAULT_SCHEMA);
        return field.isNillable() ? Schema.nullableOf((Schema)fieldSchema) : fieldSchema;
    }
}

