/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce;

import io.cdap.cdap.api.data.schema.Schema;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class SalesforceTransformUtil {
    public static Object transformLogicalType(String fieldName, Schema.LogicalType logicalType, String value) {
        switch (logicalType) {
            case DATE: {
                return Math.toIntExact(LocalDate.parse(value).toEpochDay());
            }
            case TIMESTAMP_MICROS: {
                return TimeUnit.MILLISECONDS.toMicros(Instant.parse(value).toEpochMilli());
            }
            case TIME_MICROS: {
                return TimeUnit.NANOSECONDS.toMicros(LocalTime.parse(value, DateTimeFormatter.ISO_TIME).toNanoOfDay());
            }
        }
        throw new IllegalArgumentException(String.format("Field '%s' is of unsupported type '%s'", fieldName, logicalType.getToken()));
    }
}

