/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.authenticator;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.sforce.ws.ConnectorConfig;
import io.cdap.plugin.salesforce.authenticator.AuthResponse;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class Authenticator {
    private static final Gson GSON = new Gson();

    public static ConnectorConfig createConnectorConfig(AuthenticatorCredentials credentials) {
        try {
            OAuthInfo oAuthInfo = Authenticator.getOAuthInfo(credentials);
            ConnectorConfig connectorConfig = new ConnectorConfig();
            connectorConfig.setSessionId(oAuthInfo.getAccessToken());
            String apiVersion = "53.0";
            String restEndpoint = String.format("%s/services/async/%s", oAuthInfo.getInstanceURL(), apiVersion);
            String serviceEndPoint = String.format("%s/services/Soap/u/%s", oAuthInfo.getInstanceURL(), apiVersion);
            connectorConfig.setRestEndpoint(restEndpoint);
            connectorConfig.setServiceEndpoint(serviceEndPoint);
            connectorConfig.setCompression(true);
            connectorConfig.setTraceMessage(false);
            return connectorConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Connection to salesforce with plugin configurations failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OAuthInfo getOAuthInfo(AuthenticatorCredentials credentials) throws Exception {
        OAuthInfo oAuthInfo = credentials.getOAuthInfo();
        if (oAuthInfo != null) {
            return oAuthInfo;
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        HttpClient httpClient = new HttpClient(sslContextFactory);
        try {
            httpClient.start();
            String response = httpClient.POST(credentials.getLoginUrl()).param("grant_type", "password").param("client_id", credentials.getConsumerKey()).param("client_secret", credentials.getConsumerSecret()).param("username", credentials.getUsername()).param("password", credentials.getPassword()).send().getContentAsString();
            AuthResponse authResponse = (AuthResponse)GSON.fromJson(response, AuthResponse.class);
            if (!Strings.isNullOrEmpty((String)authResponse.getError())) {
                throw new IllegalArgumentException(String.format("Cannot authenticate to Salesforce with given credentials. ServerResponse='%s'", response));
            }
            OAuthInfo oAuthInfo2 = new OAuthInfo(authResponse.getAccessToken(), authResponse.getInstanceUrl());
            return oAuthInfo2;
        }
        finally {
            httpClient.stop();
        }
    }
}

