/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.authenticator;

import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class AuthenticatorCredentials
implements Serializable {
    private final OAuthInfo oAuthInfo;
    private final String username;
    private final String password;
    private final String consumerKey;
    private final String consumerSecret;
    private final String loginUrl;

    public AuthenticatorCredentials(OAuthInfo oAuthInfo) {
        this(Objects.requireNonNull(oAuthInfo), null, null, null, null, null);
    }

    public AuthenticatorCredentials(String username, String password, String consumerKey, String consumerSecret, String loginUrl) {
        this(null, Objects.requireNonNull(username), Objects.requireNonNull(password), Objects.requireNonNull(consumerKey), Objects.requireNonNull(consumerSecret), Objects.requireNonNull(loginUrl));
    }

    private AuthenticatorCredentials(@Nullable OAuthInfo oAuthInfo, @Nullable String username, @Nullable String password, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String loginUrl) {
        this.oAuthInfo = oAuthInfo;
        this.username = username;
        this.password = password;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.loginUrl = loginUrl;
    }

    @Nullable
    public OAuthInfo getOAuthInfo() {
        return this.oAuthInfo;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Nullable
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    @Nullable
    public String getLoginUrl() {
        return this.loginUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorCredentials that = (AuthenticatorCredentials)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret) && Objects.equals(this.loginUrl, that.loginUrl);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.consumerKey, this.consumerSecret, this.loginUrl);
    }
}

