/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.parser;

import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.parser.SOQLParsingException;
import io.cdap.plugin.salesforce.parser.SalesforceQueryVisitor;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import soql.SOQLLexer;
import soql.SOQLParser;

public class SalesforceQueryParser {
    public static SObjectDescriptor getObjectDescriptorFromQuery(String query) {
        SOQLParser parser = SalesforceQueryParser.initParser(query);
        SalesforceQueryVisitor visitor = new SalesforceQueryVisitor();
        return (SObjectDescriptor)visitor.visit((ParseTree)parser.statement());
    }

    public static String getFromStatement(String query) {
        SOQLParser parser = SalesforceQueryParser.initParser(query);
        SalesforceQueryVisitor.FromStatementVisitor visitor = new SalesforceQueryVisitor.FromStatementVisitor();
        return (String)visitor.visit((ParseTree)parser.statement());
    }

    public static boolean isRestrictedQuery(String query) {
        SOQLParser parser = SalesforceQueryParser.initParser(query);
        SalesforceQueryVisitor.RestrictedQueryVisitor visitor = new SalesforceQueryVisitor.RestrictedQueryVisitor();
        return (Boolean)visitor.visit((ParseTree)parser.statement());
    }

    public static boolean isRestrictedPKQuery(String query) {
        SOQLParser parser = SalesforceQueryParser.initParser(query);
        SalesforceQueryVisitor.RestrictedPKQueryVisitor visitor = new SalesforceQueryVisitor.RestrictedPKQueryVisitor();
        return (Boolean)visitor.visit((ParseTree)parser.statement());
    }

    private static SOQLParser initParser(String query) {
        SOQLLexer lexer = new SOQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SOQLParser parser = new SOQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        return parser;
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("Line [").append(line).append("]");
            builder.append(", position [").append(charPositionInLine).append("]");
            if (offendingSymbol != null) {
                builder.append(", offending symbol ").append(offendingSymbol);
            }
            if (msg != null) {
                builder.append(": ").append(msg);
            }
            throw new SOQLParsingException(builder.toString());
        }
    }
}

