/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.parser;

import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceFunctionType;
import io.cdap.plugin.salesforce.parser.SOQLParsingException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.Interval;
import soql.SOQLBaseVisitor;
import soql.SOQLParser;

public class SalesforceQueryVisitor
extends SOQLBaseVisitor<SObjectDescriptor> {
    @Override
    public SObjectDescriptor visitStatement(SOQLParser.StatementContext ctx) {
        String alias;
        SOQLParser.ObjectTypeContext objectTypeContext = ctx.fromStatement().objectType();
        String string = alias = objectTypeContext.alias() == null ? null : objectTypeContext.alias().getText();
        if (objectTypeContext.id_or_keyword() == null || objectTypeContext.id_or_keyword().size() != 1) {
            throw new SOQLParsingException("Invalid top level object: " + ctx.getText());
        }
        String name = objectTypeContext.id_or_keyword().get(0).getText();
        SOQLParser.FieldListContext fieldListContext = ctx.fieldList();
        List fields = (List)fieldListContext.accept(new FieldListVisitor(name, alias, false));
        if (fields.isEmpty()) {
            throw new SOQLParsingException("SOQL must have at least one field: " + ctx.getText());
        }
        if (ctx.fromStatement().GROUP() == null) {
            List aliasedFields = fields.stream().filter(fieldDescriptor -> fieldDescriptor.getFunctionType() == SalesforceFunctionType.NONE).filter(SObjectDescriptor.FieldDescriptor::hasAlias).map(SObjectDescriptor.FieldDescriptor::getFullName).collect(Collectors.toList());
            if (!aliasedFields.isEmpty()) {
                throw new SOQLParsingException("Field aliasing is not allowed except when using a GROUP BY clause. List of fields with alias: " + aliasedFields);
            }
        } else {
            List unAliasedFields = fields.stream().filter(fieldDescriptor -> !fieldDescriptor.hasAlias()).filter(SObjectDescriptor.FieldDescriptor::hasParents).map(SObjectDescriptor.FieldDescriptor::getFullName).collect(Collectors.toList());
            if (!unAliasedFields.isEmpty()) {
                throw new SOQLParsingException("Reference fields must have an alias when using a GROUP BY clause. List of reference fields without alias: " + unAliasedFields);
            }
        }
        List childSObjects = (List)fieldListContext.accept(new SubQueryListVisitor());
        return new SObjectDescriptor(name, fields, childSObjects);
    }

    public static class RestrictedPKQueryVisitor
    extends SOQLBaseVisitor<Boolean> {
        @Override
        public Boolean visitStatement(SOQLParser.StatementContext ctx) {
            SOQLParser.FromStatementContext fromStatementContext = ctx.fromStatement();
            if (fromStatementContext.WITH() != null || fromStatementContext.GROUP() != null || fromStatementContext.ORDER() != null || fromStatementContext.LIMIT() != null || fromStatementContext.OFFSET() != null || fromStatementContext.FOR() != null) {
                return true;
            }
            return (Boolean)ctx.fieldList().accept(new RestrictedFieldVisitor());
        }
    }

    public static class RestrictedFieldVisitor
    extends SOQLBaseVisitor<Boolean> {
        @Override
        public Boolean visitFunctionCall(SOQLParser.FunctionCallContext ctx) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitSubquery(SOQLParser.SubqueryContext ctx) {
            return Boolean.TRUE;
        }

        protected Boolean defaultResult() {
            return Boolean.FALSE;
        }
    }

    public static class RestrictedQueryVisitor
    extends SOQLBaseVisitor<Boolean> {
        @Override
        public Boolean visitStatement(SOQLParser.StatementContext ctx) {
            SOQLParser.FromStatementContext fromStatementContext = ctx.fromStatement();
            if (fromStatementContext.GROUP() != null || fromStatementContext.OFFSET() != null) {
                return true;
            }
            return (Boolean)ctx.fieldList().accept(new RestrictedFieldVisitor());
        }
    }

    public static class FromStatementVisitor
    extends SOQLBaseVisitor<String> {
        @Override
        public String visitStatement(SOQLParser.StatementContext ctx) {
            SOQLParser.FromStatementContext fromStatementContext = ctx.fromStatement();
            Interval interval = new Interval(fromStatementContext.start.getStartIndex(), fromStatementContext.stop.getStopIndex());
            return fromStatementContext.start.getInputStream().getText(interval);
        }
    }

    private class SubQueryVisitor
    extends SOQLBaseVisitor<SObjectDescriptor> {
        private SubQueryVisitor() {
        }

        @Override
        public SObjectDescriptor visitSubquery(SOQLParser.SubqueryContext ctx) {
            SOQLParser.ObjectTypeContext objectTypeContext = ctx.objectType();
            if (objectTypeContext.id_or_keyword() == null || objectTypeContext.id_or_keyword().size() != 1) {
                throw new SOQLParsingException("Invalid top level object: " + ctx.getText());
            }
            String name = objectTypeContext.id_or_keyword().get(0).getText();
            String alias = objectTypeContext.alias() == null ? null : objectTypeContext.alias().getText();
            SOQLParser.FieldListContext fieldListContext = ctx.fieldList();
            FieldListVisitor visitor = new FieldListVisitor(name, alias, true);
            List fields = (List)fieldListContext.accept(visitor);
            return new SObjectDescriptor(name, fields);
        }
    }

    private class SubQueryListVisitor
    extends SOQLBaseVisitor<List<SObjectDescriptor>> {
        private SubQueryListVisitor() {
        }

        @Override
        public List<SObjectDescriptor> visitStarElement(SOQLParser.StarElementContext ctx) {
            throw new SOQLParsingException("Star queries are not supported in sub-queries: " + ctx.getText());
        }

        @Override
        public List<SObjectDescriptor> visitFieldElements(SOQLParser.FieldElementsContext ctx) {
            SubQueryVisitor visitor = new SubQueryVisitor();
            return ctx.fieldElement().stream().map(f -> f.accept(visitor)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    private class FieldVisitor
    extends SOQLBaseVisitor<SObjectDescriptor.FieldDescriptor> {
        private final String objectName;
        private final String objectAlias;
        private final boolean requireAlias;
        private final boolean subQueryScope;

        FieldVisitor(String objectName, String objectAlias, boolean requireAlias, boolean subQueryScope) {
            this.objectName = objectName;
            this.objectAlias = objectAlias;
            this.requireAlias = requireAlias;
            this.subQueryScope = subQueryScope;
        }

        @Override
        public SObjectDescriptor.FieldDescriptor visitFieldName(SOQLParser.FieldNameContext ctx) {
            String topParent;
            List<String> nameParts = ctx.field().id_or_keyword().stream().map(RuleContext::getText).collect(Collectors.toList());
            if (nameParts.isEmpty()) {
                throw new SOQLParsingException("Invalid column name: " + ctx.getText());
            }
            if (nameParts.size() > 1 && ((topParent = (String)nameParts.get(0)).equalsIgnoreCase(this.objectName) || topParent.equals(this.objectAlias))) {
                nameParts = nameParts.subList(1, nameParts.size());
            }
            String alias = ctx.alias() == null ? null : ctx.alias().getText();
            return new SObjectDescriptor.FieldDescriptor(nameParts, alias, SalesforceFunctionType.NONE);
        }

        @Override
        public SObjectDescriptor.FieldDescriptor visitSubquery(SOQLParser.SubqueryContext ctx) {
            if (this.subQueryScope) {
                throw new SOQLParsingException("Sub-queries are not supported inside of other sub-queries: " + ctx.getText());
            }
            return null;
        }

        @Override
        public SObjectDescriptor.FieldDescriptor visitFunctionCall(SOQLParser.FunctionCallContext ctx) {
            FieldVisitor visitor;
            String alias;
            if (this.subQueryScope) {
                throw new SOQLParsingException("Function calls are not supported in sub-queries: " + ctx.getText());
            }
            SOQLParser.AliasContext aliasContext = ctx.alias();
            String string = alias = aliasContext == null ? null : aliasContext.getText();
            if (this.requireAlias && alias == null) {
                throw new SOQLParsingException("Function call must have alias: " + ctx.getText());
            }
            SOQLParser.FunctionContext function = ctx.function();
            String functionName = function.functionName().getText();
            SalesforceFunctionType functionType = SalesforceFunctionType.get(functionName);
            if (functionType.isConstant()) {
                return new SObjectDescriptor.FieldDescriptor(Collections.singletonList(alias), alias, functionType);
            }
            SOQLParser.FieldElementContext fieldElementContext = function.fieldElement();
            SObjectDescriptor.FieldDescriptor result = fieldElementContext.accept(visitor = new FieldVisitor(this.objectName, this.objectAlias, false, false));
            if (result == null) {
                throw new SOQLParsingException("Function must be applied to the named field: " + ctx.getText());
            }
            return new SObjectDescriptor.FieldDescriptor(result.getNameParts(), alias, functionType);
        }

        @Override
        public SObjectDescriptor.FieldDescriptor visitTypeOfClause(SOQLParser.TypeOfClauseContext ctx) {
            throw new SOQLParsingException("TypeOf clauses are not supported: " + ctx.getText());
        }
    }

    private class FieldListVisitor
    extends SOQLBaseVisitor<List<SObjectDescriptor.FieldDescriptor>> {
        private final String objectName;
        private final String objectAlias;
        private final boolean subQueryScope;

        FieldListVisitor(String objectName, String objectAlias, boolean subQueryScope) {
            this.objectName = objectName;
            this.objectAlias = objectAlias;
            this.subQueryScope = subQueryScope;
        }

        @Override
        public List<SObjectDescriptor.FieldDescriptor> visitStarElement(SOQLParser.StarElementContext ctx) {
            throw new SOQLParsingException("Star queries are not supported: " + ctx.getText());
        }

        @Override
        public List<SObjectDescriptor.FieldDescriptor> visitFieldElements(SOQLParser.FieldElementsContext ctx) {
            FieldVisitor fieldVisitor = new FieldVisitor(this.objectName, this.objectAlias, true, this.subQueryScope);
            return ctx.fieldElement().stream().map(f -> f.accept(fieldVisitor)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

