/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin;

import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ReferencePluginConfig;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import javax.annotation.Nullable;

public class BaseSalesforceConfig
extends ReferencePluginConfig {
    @Name(value="oAuthInfo")
    @Description(value="OAuth information for connecting to Salesforce. It is expected to be an json string containing two properties, \"accessToken\" and \"instanceURL\", which carry the OAuth access token and the URL to connect to respectively. Use the ${oauth(provider, credentialId)} macro function for acquiring OAuth information dynamically. ")
    @Macro
    @Nullable
    private OAuthInfo oAuthInfo;
    @Name(value="consumerKey")
    @Description(value="Salesforce connected app's consumer key")
    @Macro
    @Nullable
    private String consumerKey;
    @Name(value="consumerSecret")
    @Description(value="Salesforce connected app's client secret key")
    @Macro
    @Nullable
    private String consumerSecret;
    @Name(value="username")
    @Description(value="Salesforce username")
    @Macro
    @Nullable
    private String username;
    @Name(value="password")
    @Description(value="Salesforce password")
    @Macro
    @Nullable
    private String password;
    @Name(value="securityToken")
    @Description(value="Salesforce security token")
    @Macro
    @Nullable
    private String securityToken;
    @Name(value="loginUrl")
    @Description(value="Endpoint to authenticate to")
    @Macro
    @Nullable
    private String loginUrl;

    public BaseSalesforceConfig(String referenceName, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, @Nullable String securityToken, @Nullable OAuthInfo oAuthInfo) {
        super(referenceName);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.username = username;
        this.password = password;
        this.loginUrl = loginUrl;
        this.securityToken = securityToken;
        this.oAuthInfo = oAuthInfo;
    }

    @Nullable
    public OAuthInfo getOAuthInfo() {
        return this.oAuthInfo;
    }

    @Nullable
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Nullable
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.constructPasswordWithToken(this.password, this.securityToken);
    }

    @Nullable
    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void validate(FailureCollector collector) {
        try {
            this.validateConnection();
        }
        catch (Exception e) {
            collector.addFailure("Error encountered while establishing connection: " + e.getMessage(), "Please verify authentication properties are provided correctly").withStacktrace(e.getStackTrace());
        }
        collector.getOrThrowException();
    }

    public AuthenticatorCredentials getAuthenticatorCredentials() {
        OAuthInfo oAuthInfo = this.getOAuthInfo();
        if (oAuthInfo != null) {
            return new AuthenticatorCredentials(oAuthInfo);
        }
        return new AuthenticatorCredentials(this.getUsername(), this.getPassword(), this.getConsumerKey(), this.getConsumerSecret(), this.getLoginUrl());
    }

    public boolean canAttemptToEstablishConnection() {
        if (this.getOAuthInfo() != null) {
            return true;
        }
        if (this.containsMacro("oAuthInfo")) {
            return false;
        }
        return !this.containsMacro("consumerKey") && !this.containsMacro("consumerSecret") && !this.containsMacro("username") && !this.containsMacro("password") && !this.containsMacro("loginUrl") && !this.containsMacro("securityToken");
    }

    private void validateConnection() {
        if (!this.canAttemptToEstablishConnection()) {
            return;
        }
        try {
            SalesforceConnectionUtil.getPartnerConnection(this.getAuthenticatorCredentials());
        }
        catch (ConnectionException e) {
            throw new RuntimeException("There was issue communicating with Salesforce. " + e.getMessage(), e);
        }
    }

    private String constructPasswordWithToken(String password, @Nullable String securityToken) {
        if (securityToken != null && !securityToken.isEmpty() && !password.endsWith(securityToken)) {
            return password + securityToken;
        }
        return password;
    }
}

