/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class CSVBuffer
implements Closeable {
    private static final CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[0]).withQuoteMode(QuoteMode.ALL).withAllowMissingColumnNames(false);
    private CSVPrinter csvPrinter;
    private ByteArrayOutputStream csvStream;
    private boolean isHeaderPrinted;
    private boolean printHeader;
    private int recordsCount = 0;

    public CSVBuffer(boolean printHeader) throws IOException {
        this.printHeader = printHeader;
        this.csvStream = new ByteArrayOutputStream();
        this.reset();
    }

    public void write(CSVRecord csvRecord) throws IOException {
        if (!this.isHeaderPrinted) {
            this.csvPrinter.printRecord(csvRecord.getColumnNames());
            this.isHeaderPrinted = true;
        }
        this.csvPrinter.printRecord((Iterable)csvRecord);
        this.csvPrinter.flush();
        ++this.recordsCount;
    }

    public void reset() throws IOException {
        this.isHeaderPrinted = !this.printHeader;
        this.recordsCount = 0;
        this.csvStream.reset();
        this.csvPrinter = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)this.csvStream, StandardCharsets.UTF_8), csvFormat);
    }

    public int size() {
        return this.csvStream.size();
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public byte[] getByteArray() {
        return this.csvStream.toByteArray();
    }

    @Override
    public void close() throws IOException {
        this.csvPrinter.close(true);
    }
}

