/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CSVRecord
implements Iterable<String> {
    private final List<String> columnNames;
    private final List<String> values;

    public CSVRecord(List<String> columnNames, List<String> values) {
        this.columnNames = columnNames;
        this.values = values;
        Preconditions.checkState((columnNames.size() == values.size() ? 1 : 0) != 0, (Object)String.format("Cannot create CSVRecord, with number of columns %d not equal to number of values %d", columnNames.size(), values.size()));
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSVRecord that = (CSVRecord)o;
        return Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.columnNames, this.values);
    }

    public String toString() {
        return "CSVRecord{columnNames=" + Arrays.toString(this.columnNames.toArray()) + ", values=" + Arrays.toString(this.values.toArray()) + '}';
    }
}

