/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Output;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.StageConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchRuntimeContext;
import io.cdap.cdap.etl.api.batch.BatchSink;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import io.cdap.plugin.salesforce.plugin.sink.batch.SalesforceOutputFormatProvider;
import io.cdap.plugin.salesforce.plugin.sink.batch.SalesforceSinkConfig;
import io.cdap.plugin.salesforce.plugin.sink.batch.StructuredRecordToCSVRecordTransformer;
import java.util.stream.Collectors;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="batchsink")
@Name(value="Salesforce")
@Description(value="Writes records to Salesforce")
public class SalesforceBatchSink
extends BatchSink<StructuredRecord, NullWritable, CSVRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceBatchSink.class);
    public static final String PLUGIN_NAME = "Salesforce";
    private final SalesforceSinkConfig config;
    private StructuredRecordToCSVRecordTransformer transformer;

    public SalesforceBatchSink(SalesforceSinkConfig config) throws ConnectionException {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        super.configurePipeline(pipelineConfigurer);
        StageConfigurer stageConfigurer = pipelineConfigurer.getStageConfigurer();
        this.config.validate(stageConfigurer.getInputSchema(), stageConfigurer.getFailureCollector());
    }

    public void prepareRun(BatchSinkContext context) {
        Schema inputSchema = context.getInputSchema();
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(inputSchema, collector);
        collector.getOrThrowException();
        context.addOutput(Output.of((String)this.config.referenceName, (OutputFormatProvider)new SalesforceOutputFormatProvider(this.config)));
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, this.config.referenceName);
        lineageRecorder.createExternalDataset(inputSchema);
        if (inputSchema.getFields() != null && !inputSchema.getFields().isEmpty()) {
            String operationDescription = String.format("Wrote to Salesforce %s", this.config.getSObject());
            lineageRecorder.recordWrite("Write", operationDescription, inputSchema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList()));
        }
    }

    public void initialize(BatchRuntimeContext context) throws Exception {
        super.initialize(context);
        this.transformer = new StructuredRecordToCSVRecordTransformer();
    }

    public void transform(StructuredRecord record, Emitter<KeyValue<NullWritable, CSVRecord>> emitter) {
        CSVRecord csvRecord = this.transformer.transform(record);
        emitter.emit((Object)new KeyValue(null, (Object)csvRecord));
    }
}

