/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import io.cdap.plugin.salesforce.SalesforceBulkUtil;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import io.cdap.plugin.salesforce.plugin.sink.batch.SalesforceRecordWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SalesforceOutputFormat
extends OutputFormat<NullWritable, CSVRecord> {
    public RecordWriter<NullWritable, CSVRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        try {
            return new SalesforceRecordWriter(taskAttemptContext);
        }
        catch (AsyncApiException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
    }

    public void checkOutputSpecs(JobContext jobContext) {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) {
        return new OutputCommitter(){

            public void setupJob(JobContext jobContext) {
            }

            public void commitJob(JobContext jobContext) {
                Configuration conf = jobContext.getConfiguration();
                AuthenticatorCredentials credentials = SalesforceConnectionUtil.getAuthenticatorCredentials(conf);
                try {
                    BulkConnection bulkConnection = new BulkConnection(Authenticator.createConnectorConfig(credentials));
                    String jobId = conf.get("mapred.salesforce.job.id");
                    SalesforceBulkUtil.closeJob(bulkConnection, jobId);
                }
                catch (AsyncApiException e) {
                    throw new RuntimeException("There was issue communicating with Salesforce", e);
                }
            }

            public void setupTask(TaskAttemptContext taskAttemptContext) {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) {
                return true;
            }

            public void commitTask(TaskAttemptContext taskAttemptContext) {
            }

            public void abortTask(TaskAttemptContext taskAttemptContext) {
            }
        };
    }
}

