/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.google.common.collect.ImmutableMap;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.async.JobInfo;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.plugin.salesforce.SalesforceBulkUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.plugin.sink.batch.SalesforceOutputFormat;
import io.cdap.plugin.salesforce.plugin.sink.batch.SalesforceSinkConfig;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceOutputFormatProvider
implements OutputFormatProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceOutputFormatProvider.class);
    private final Map<String, String> configMap;

    public SalesforceOutputFormatProvider(SalesforceSinkConfig config) {
        ImmutableMap.Builder configBuilder = new ImmutableMap.Builder().put((Object)"mapred.salesforce.sobject.name", (Object)config.getSObject()).put((Object)"mapred.salesforce.operation.type", (Object)config.getOperation()).put((Object)"mapred.salesforce.error.handling", (Object)config.getErrorHandling().getValue()).put((Object)"mapred.salesforce.max.bytes.per.batch", (Object)config.getMaxBytesPerBatch().toString()).put((Object)"mapred.salesforce.max.records.per.batch", (Object)config.getMaxRecordsPerBatch().toString());
        OAuthInfo oAuthInfo = config.getOAuthInfo();
        if (oAuthInfo != null) {
            configBuilder.put((Object)"mapred.salesforce.oauth.token", (Object)oAuthInfo.getAccessToken()).put((Object)"mapred.salesforce.oauth.instance.url", (Object)oAuthInfo.getInstanceURL());
        } else {
            configBuilder.put((Object)"mapred.salesforce.user", (Object)Objects.requireNonNull(config.getUsername())).put((Object)"mapred.salesforce.password", (Object)Objects.requireNonNull(config.getPassword())).put((Object)"mapred.salesforce.consumer.key", (Object)Objects.requireNonNull(config.getConsumerKey())).put((Object)"mapred.salesforce.consumer.secret", (Object)Objects.requireNonNull(config.getConsumerSecret())).put((Object)"mapred.salesforce.login.url", (Object)Objects.requireNonNull(config.getLoginUrl()));
        }
        if (config.getExternalIdField() != null) {
            configBuilder.put((Object)"mapred.salesforce.external.id", (Object)config.getExternalIdField());
        }
        AuthenticatorCredentials credentials = config.getAuthenticatorCredentials();
        try {
            BulkConnection bulkConnection = new BulkConnection(Authenticator.createConnectorConfig(credentials));
            JobInfo job = SalesforceBulkUtil.createJob(bulkConnection, config.getSObject(), config.getOperationEnum(), config.getExternalIdField());
            configBuilder.put((Object)"mapred.salesforce.job.id", (Object)job.getId());
            LOG.info("Started Salesforce job with jobId='{}'", (Object)job.getId());
        }
        catch (AsyncApiException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
        this.configMap = configBuilder.build();
    }

    public String getOutputFormatClassName() {
        return SalesforceOutputFormat.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        return this.configMap;
    }
}

