/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BulkConnection;
import com.sforce.async.JobInfo;
import io.cdap.plugin.salesforce.SalesforceBulkUtil;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVBuffer;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import io.cdap.plugin.salesforce.plugin.sink.batch.ErrorHandling;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceRecordWriter
extends RecordWriter<NullWritable, CSVRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceRecordWriter.class);
    private BulkConnection bulkConnection;
    private JobInfo jobInfo;
    private ErrorHandling errorHandling;
    private Long maxBytesPerBatch;
    private Long maxRecordsPerBatch;
    private List<BatchInfo> batchInfoList = new ArrayList<BatchInfo>();
    private CSVBuffer csvBuffer;
    private CSVBuffer csvBufferSizeCheck;

    public SalesforceRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, AsyncApiException {
        Configuration conf = taskAttemptContext.getConfiguration();
        String jobId = conf.get("mapred.salesforce.job.id");
        this.errorHandling = ErrorHandling.fromValue(conf.get("mapred.salesforce.error.handling")).get();
        this.maxBytesPerBatch = Long.parseLong(conf.get("mapred.salesforce.max.bytes.per.batch"));
        this.maxRecordsPerBatch = Long.parseLong(conf.get("mapred.salesforce.max.records.per.batch"));
        this.csvBuffer = new CSVBuffer(true);
        this.csvBufferSizeCheck = new CSVBuffer(false);
        AuthenticatorCredentials credentials = SalesforceConnectionUtil.getAuthenticatorCredentials(conf);
        this.bulkConnection = new BulkConnection(Authenticator.createConnectorConfig(credentials));
        this.jobInfo = this.bulkConnection.getJobStatus(jobId);
    }

    public void write(NullWritable key, CSVRecord csvRecord) throws IOException {
        this.csvBufferSizeCheck.reset();
        this.csvBufferSizeCheck.write(csvRecord);
        if ((long)(this.csvBuffer.size() + this.csvBufferSizeCheck.size()) > this.maxBytesPerBatch || (long)this.csvBuffer.getRecordsCount() >= this.maxRecordsPerBatch) {
            this.submitCurrentBatch();
        }
        this.csvBuffer.write(csvRecord);
    }

    private void submitCurrentBatch() throws IOException {
        if (this.csvBuffer.getRecordsCount() != 0) {
            ByteArrayInputStream csvInputStream = new ByteArrayInputStream(this.csvBuffer.getByteArray());
            try {
                BatchInfo batchInfo = this.bulkConnection.createBatchFromStream(this.jobInfo, (InputStream)csvInputStream);
                this.batchInfoList.add(batchInfo);
                LOG.info("Submitted a batch with batchId='{}'", (Object)batchInfo.getId());
            }
            catch (AsyncApiException e) {
                throw new RuntimeException("There was issue communicating with Salesforce", e);
            }
            this.csvBuffer.reset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(TaskAttemptContext taskAttemptContext) throws IOException {
        this.submitCurrentBatch();
        try {
            SalesforceBulkUtil.awaitCompletion(this.bulkConnection, this.jobInfo, this.batchInfoList);
            SalesforceBulkUtil.checkResults(this.bulkConnection, this.jobInfo, this.batchInfoList, this.errorHandling.equals((Object)ErrorHandling.SKIP));
            return;
        }
        catch (AsyncApiException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
        finally {
            try {
                this.csvBufferSizeCheck.close();
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                this.csvBuffer.close();
            }
        }
    }
}

