/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import com.google.common.base.Strings;
import com.sforce.async.OperationEnum;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.validation.InvalidStageException;
import io.cdap.plugin.salesforce.InvalidConfigException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectsDescribeResult;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.BaseSalesforceConfig;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.plugin.sink.batch.ErrorHandling;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SalesforceSinkConfig
extends BaseSalesforceConfig {
    public static final String PROPERTY_ERROR_HANDLING = "errorHandling";
    public static final String PROPERTY_MAX_BYTES_PER_BATCH = "maxBytesPerBatch";
    public static final String PROPERTY_MAX_RECORDS_PER_BATCH = "maxRecordsPerBatch";
    public static final String PROPERTY_SOBJECT = "sObject";
    public static final String PROPERTY_OPERATION = "operation";
    public static final String PROPERTY_EXTERNAL_ID_FIELD = "externalIdField";
    private static final String SALESFORCE_ID_FIELD = "Id";
    private static final long MAX_BYTES_PER_BATCH_LIMIT = 10000000L;
    private static final long MAX_RECORDS_PER_BATCH_LIMIT = 10000L;
    @Name(value="sObject")
    @Description(value="Salesforce object name to insert records into.")
    @Macro
    private String sObject;
    @Name(value="operation")
    @Description(value="Operation used for sinking data into Salesforce.\nInsert - adds records.\nUpsert - upserts the records. Salesforce will decide if sObjects are the same using external id field.\nUpdate - updates existing records based on Id field.")
    @Macro
    private String operation;
    @Name(value="externalIdField")
    @Description(value="External id field name. It is used only if operation is upsert.\nThe field specified can be either 'Id' or any customly created field, which has external id attribute set.")
    @Nullable
    @Macro
    private String externalIdField;
    @Name(value="maxBytesPerBatch")
    @Description(value="Maximum size in bytes of a batch of records when writing to Salesforce. This value cannot be greater than 10,000,000.")
    @Macro
    private String maxBytesPerBatch;
    @Name(value="maxRecordsPerBatch")
    @Description(value="Maximum number of records to include in a batch when writing to Salesforce.This value cannot be greater than 10,000.")
    @Macro
    private String maxRecordsPerBatch;
    @Name(value="errorHandling")
    @Description(value="Strategy used to handle erroneous records.\nSkip on error - Ignores erroneous records.\nStop on error - Fails pipeline due to erroneous record.")
    @Macro
    private String errorHandling;

    public SalesforceSinkConfig(String referenceName, @Nullable String clientId, @Nullable String clientSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, String sObject, String operation, String externalIdField, String maxBytesPerBatch, String maxRecordsPerBatch, String errorHandling, @Nullable String securityToken, @Nullable OAuthInfo oAuthInfo) {
        super(referenceName, clientId, clientSecret, username, password, loginUrl, securityToken, oAuthInfo);
        this.sObject = sObject;
        this.operation = operation;
        this.externalIdField = externalIdField;
        this.maxBytesPerBatch = maxBytesPerBatch;
        this.maxRecordsPerBatch = maxRecordsPerBatch;
        this.errorHandling = errorHandling;
    }

    public String getSObject() {
        return this.sObject;
    }

    public String getOperation() {
        return this.operation;
    }

    public OperationEnum getOperationEnum() {
        try {
            return OperationEnum.valueOf((String)this.operation.toLowerCase());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigException("Unsupported value for operation: " + this.operation, PROPERTY_OPERATION);
        }
    }

    public String getExternalIdField() {
        return this.externalIdField;
    }

    public Long getMaxBytesPerBatch() {
        try {
            return Long.parseLong(this.maxBytesPerBatch);
        }
        catch (NumberFormatException ex) {
            throw new InvalidConfigException("Unsupported value for maxBytesPerBatch: " + this.maxBytesPerBatch, PROPERTY_MAX_BYTES_PER_BATCH);
        }
    }

    public Long getMaxRecordsPerBatch() {
        try {
            return Long.parseLong(this.maxRecordsPerBatch);
        }
        catch (NumberFormatException ex) {
            throw new InvalidConfigException("Unsupported value for maxRecordsPerBatch: " + this.maxRecordsPerBatch, PROPERTY_MAX_RECORDS_PER_BATCH);
        }
    }

    public ErrorHandling getErrorHandling() {
        return ErrorHandling.fromValue(this.errorHandling).orElseThrow(() -> new InvalidConfigException("Unsupported error handling value: " + this.errorHandling, PROPERTY_ERROR_HANDLING));
    }

    public void validate(Schema schema, FailureCollector collector) {
        long maxRecordsPerBatch;
        String errorMessage;
        long maxBytesPerBatch;
        super.validate(collector);
        if (!this.containsMacro(PROPERTY_ERROR_HANDLING)) {
            try {
                this.getErrorHandling();
            }
            catch (InvalidConfigException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(PROPERTY_ERROR_HANDLING);
            }
        }
        if (!this.containsMacro(PROPERTY_OPERATION)) {
            try {
                this.getOperationEnum();
            }
            catch (InvalidConfigException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(PROPERTY_OPERATION);
            }
        }
        if (!(this.containsMacro(PROPERTY_MAX_BYTES_PER_BATCH) || (maxBytesPerBatch = this.getMaxBytesPerBatch().longValue()) > 0L && maxBytesPerBatch <= 10000000L)) {
            errorMessage = String.format("Unsupported value for maxBytesPerBatch: %d. Value should be between 1 and %d", maxBytesPerBatch, 10000000L);
            collector.addFailure(errorMessage, null).withConfigProperty(PROPERTY_MAX_BYTES_PER_BATCH);
        }
        if (!(this.containsMacro(PROPERTY_MAX_RECORDS_PER_BATCH) || (maxRecordsPerBatch = this.getMaxRecordsPerBatch().longValue()) > 0L && maxRecordsPerBatch <= 10000L)) {
            errorMessage = String.format("Unsupported value for maxRecordsPerBatch: %d. Value should be between 1 and %d", maxRecordsPerBatch, 10000L);
            collector.addFailure(errorMessage, null).withConfigProperty(PROPERTY_MAX_RECORDS_PER_BATCH);
        }
        collector.getOrThrowException();
        this.validateSchema(schema, collector);
    }

    private void validateSchema(Schema schema, FailureCollector collector) {
        List fields = schema.getFields();
        if (fields == null || fields.isEmpty()) {
            collector.addFailure("Sink schema must contain at least one field", null);
            throw collector.getOrThrowException();
        }
        if (!this.canAttemptToEstablishConnection() || this.containsMacro(PROPERTY_SOBJECT) || this.containsMacro(PROPERTY_OPERATION) || this.containsMacro(PROPERTY_EXTERNAL_ID_FIELD)) {
            return;
        }
        SObjectsDescribeResult describeResult = this.getSObjectDescribeResult(collector);
        Set<String> creatableSObjectFields = this.getCreatableSObjectFields(describeResult);
        Set inputFields = schema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toSet());
        OperationEnum operation = this.getOperationEnum();
        String externalIdFieldName = null;
        switch (operation) {
            case insert: {
                break;
            }
            case upsert: {
                externalIdFieldName = this.getExternalIdField();
                break;
            }
            case update: {
                externalIdFieldName = SALESFORCE_ID_FIELD;
                break;
            }
            default: {
                collector.addFailure("Unsupported value for operation: " + operation, null).withConfigProperty(PROPERTY_OPERATION);
            }
        }
        if (operation == OperationEnum.upsert) {
            Field externalIdField = describeResult.getField(this.sObject, externalIdFieldName);
            if (externalIdField == null) {
                collector.addFailure(String.format("SObject '%s' does not contain external id field '%s'", this.sObject, externalIdFieldName), null).withConfigProperty(PROPERTY_EXTERNAL_ID_FIELD);
            } else if (!externalIdField.isExternalId() && !externalIdField.getName().equals(SALESFORCE_ID_FIELD)) {
                collector.addFailure(String.format("Field '%s' is not configured as external id in Salesforce", externalIdFieldName), null).withConfigProperty(PROPERTY_EXTERNAL_ID_FIELD);
            }
        } else if (!(operation != OperationEnum.insert && operation != OperationEnum.update || Strings.isNullOrEmpty((String)this.getExternalIdField()))) {
            collector.addFailure(String.format("External id field must not be set for operation='%s'", operation), null).withConfigProperty(PROPERTY_EXTERNAL_ID_FIELD);
        }
        if (externalIdFieldName != null && !inputFields.remove(externalIdFieldName)) {
            collector.addFailure(String.format("Schema must contain external id field '%s'", externalIdFieldName), null).withConfigProperty(PROPERTY_EXTERNAL_ID_FIELD);
        }
        inputFields.removeAll(creatableSObjectFields);
        if (!inputFields.isEmpty()) {
            for (String inputField : inputFields) {
                collector.addFailure(String.format("Field '%s' is not present or not creatable in target Salesforce sObject.", inputField), null).withInputSchemaField(inputField);
            }
        }
    }

    private Set<String> getCreatableSObjectFields(SObjectsDescribeResult describeResult) {
        TreeSet<String> creatableSObjectFields = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Field field : describeResult.getFields()) {
            if (!field.isCreateable()) continue;
            creatableSObjectFields.add(field.getName());
        }
        return creatableSObjectFields;
    }

    private SObjectsDescribeResult getSObjectDescribeResult(FailureCollector collector) {
        AuthenticatorCredentials credentials = this.getAuthenticatorCredentials();
        try {
            PartnerConnection partnerConnection = new PartnerConnection(Authenticator.createConnectorConfig(credentials));
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromName(this.getSObject(), this.getAuthenticatorCredentials());
            return SObjectsDescribeResult.of(partnerConnection, sObjectDescriptor.getName(), sObjectDescriptor.getFeaturedSObjects());
        }
        catch (ConnectionException e) {
            collector.addFailure("There was issue communicating with Salesforce", null).withStacktrace(e.getStackTrace());
            throw collector.getOrThrowException();
        }
    }

    private void validateInputSchema(Schema schema) {
        AuthenticatorCredentials authenticatorCredentials = this.getAuthenticatorCredentials();
        try {
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromName(this.sObject, authenticatorCredentials);
            Schema sObjectActualSchema = SalesforceSchemaUtil.getSchema(authenticatorCredentials, sObjectDescriptor);
            SalesforceSchemaUtil.checkCompatibility(sObjectActualSchema, schema, false);
        }
        catch (ConnectionException e) {
            throw new InvalidStageException("There was issue communicating with Salesforce", (Throwable)e);
        }
    }
}

