/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.sink.batch;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class StructuredRecordToCSVRecordTransformer {
    public CSVRecord transform(StructuredRecord record) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Schema.Field field : record.getSchema().getFields()) {
            String fieldName = field.getName();
            String value = StructuredRecordToCSVRecordTransformer.convertSchemaFieldToString(record.get(fieldName), field);
            fieldNames.add(fieldName);
            values.add(value);
        }
        return new CSVRecord(fieldNames, values);
    }

    public static String convertSchemaFieldToString(Object value, Schema.Field field) {
        if (value == null) {
            return null;
        }
        Schema fieldSchema = field.getSchema();
        if (fieldSchema.isNullable()) {
            fieldSchema = fieldSchema.getNonNullable();
        }
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (fieldSchema.getLogicalType() != null) {
            switch (logicalType) {
                case DATE: {
                    return LocalDate.ofEpochDay(((Integer)value).intValue()).toString();
                }
                case TIMESTAMP_MICROS: {
                    Instant instant = Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis((Long)value));
                    return instant.toString();
                }
                case TIME_MICROS: {
                    Instant instant = Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis((Long)value));
                    return instant.atZone(ZoneOffset.UTC).toLocalTime().toString();
                }
                case TIMESTAMP_MILLIS: {
                    Instant instant = Instant.ofEpochMilli((Long)value);
                    return instant.toString();
                }
                case TIME_MILLIS: {
                    Instant instant = Instant.ofEpochMilli((Long)value);
                    return instant.atZone(ZoneOffset.UTC).toLocalTime().toString();
                }
            }
            throw new IllegalArgumentException(String.format("Field '%s' is of unsupported type '%s'", field.getName(), logicalType.getToken()));
        }
        return value.toString();
    }
}

