/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.base.Strings;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.SalesforceTransformUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MapToRecordTransformer {
    public StructuredRecord transform(Schema schema, Map<String, ?> record) {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        this.transformRecord(schema, record, builder);
        return builder.build();
    }

    private void transformRecord(Schema schema, Map<String, ?> record, StructuredRecord.Builder builder) {
        for (Map.Entry<String, ?> entry : record.entrySet()) {
            String fieldName = SalesforceSchemaUtil.normalizeAvroName(entry.getKey());
            Schema.Field field = schema.getField(fieldName);
            if (field == null) continue;
            builder.set(fieldName, this.convertValue(field.getName(), entry.getValue(), field.getSchema()));
        }
    }

    private Object convertValue(String fieldName, Object value, Schema fieldSchema) {
        if (fieldSchema.isNullable()) {
            return value == null ? null : this.convertValue(fieldName, value, fieldSchema.getNonNullable());
        }
        if (value == null) {
            throw new RuntimeException(String.format("Found null value for non nullable field %s", fieldName));
        }
        Schema.Type fieldSchemaType = fieldSchema.getType();
        if (value instanceof String && Strings.isNullOrEmpty((String)((String)value))) {
            return null;
        }
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (fieldSchema.getLogicalType() != null) {
            return SalesforceTransformUtil.transformLogicalType(fieldName, logicalType, String.valueOf(value));
        }
        switch (fieldSchemaType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(this.castValue(value, fieldName, String.class));
            }
            case INT: {
                return Integer.parseInt(this.castValue(value, fieldName, String.class));
            }
            case LONG: {
                return Long.parseLong(this.castValue(value, fieldName, String.class));
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(this.castValue(value, fieldName, String.class)));
            }
            case DOUBLE: {
                return Double.parseDouble(this.castValue(value, fieldName, String.class));
            }
            case STRING: {
                return value;
            }
            case RECORD: {
                Map recordValues = (Map)this.castGeneric(this.castValue(value, fieldName, Map.class));
                StructuredRecord.Builder nestedBuilder = StructuredRecord.builder((Schema)fieldSchema);
                Objects.requireNonNull(fieldSchema.getFields()).forEach(field -> this.transformRecord(fieldSchema, recordValues, nestedBuilder));
                return nestedBuilder.build();
            }
            case ARRAY: {
                List list = (List)this.castGeneric(this.castValue(value, fieldName, List.class));
                Schema componentSchema = Objects.requireNonNull(fieldSchema.getComponentSchema());
                return list.stream().map(map -> this.convertValue(fieldName, map, componentSchema)).collect(Collectors.toList());
            }
        }
        throw new UnexpectedFormatException(String.format("Unsupported schema type: '%s' for field: '%s'. Supported types are 'boolean, int, long, float,double, string, record, array'.", fieldSchema, fieldName));
    }

    private <T> T castValue(Object value, String fieldName, Class<T> clazz) {
        if (clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        throw new UnexpectedFormatException(String.format("Field '%s' is not of expected type '%s'", fieldName, clazz.getSimpleName()));
    }

    private <T> T castGeneric(Object value) {
        return (T)value;
    }
}

