/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.sforce.async.OperationEnum;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.salesforce.InvalidConfigException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectFilterDescriptor;
import io.cdap.plugin.salesforce.SalesforceQueryUtil;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.plugin.BaseSalesforceConfig;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SalesforceBaseSourceConfig
extends BaseSalesforceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceBaseSourceConfig.class);
    @Name(value="datetimeAfter")
    @Description(value="Salesforce SObject query datetime filter. Example: 2019-03-12T11:29:52Z")
    @Nullable
    @Macro
    private String datetimeAfter;
    @Name(value="datetimeBefore")
    @Description(value="Salesforce SObject query datetime filter. Example: 2019-03-12T11:29:52Z")
    @Nullable
    @Macro
    private String datetimeBefore;
    @Name(value="duration")
    @Description(value="Salesforce SObject query duration.")
    @Nullable
    @Macro
    private String duration;
    @Name(value="offset")
    @Description(value="Salesforce SObject query offset.")
    @Nullable
    @Macro
    private String offset;
    @Name(value="operation")
    @Description(value="If set to query, the query result will only return current rows. If set to queryAll, all records, including deletes will be sourced")
    @Nullable
    private String operation;
    private static final String DEFAULT_OPERATION = "query";

    protected SalesforceBaseSourceConfig(String referenceName, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, @Nullable String datetimeAfter, @Nullable String datetimeBefore, @Nullable String duration, @Nullable String offset, @Nullable String securityToken, @Nullable OAuthInfo oAuthInfo, @Nullable String operation) {
        super(referenceName, consumerKey, consumerSecret, username, password, loginUrl, securityToken, oAuthInfo);
        this.datetimeAfter = datetimeAfter;
        this.datetimeBefore = datetimeBefore;
        this.duration = duration;
        this.offset = offset;
        this.operation = operation;
    }

    public Map<ChronoUnit, Integer> getDuration() {
        return this.extractRangeValue("duration", this.duration);
    }

    public Map<ChronoUnit, Integer> getOffset() {
        return this.extractRangeValue("offset", this.offset);
    }

    @Nullable
    public String getDatetimeAfter() {
        return this.datetimeAfter;
    }

    @Nullable
    public String getDatetimeBefore() {
        return this.datetimeBefore;
    }

    protected void validateFilters(FailureCollector collector) {
        try {
            this.validateIntervalFilterProperty("datetimeAfter", this.getDatetimeAfter());
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
        try {
            this.validateIntervalFilterProperty("datetimeBefore", this.getDatetimeBefore());
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
        try {
            this.validateRangeFilterProperty("duration", this.getDuration());
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
        try {
            this.validateRangeFilterProperty("offset", this.getOffset());
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
        try {
            this.validateOperationProperty("operation", this.getOperation());
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
    }

    protected String getSObjectQuery(String sObjectName, Schema schema, long logicalStartTime) {
        try {
            List<String> fieldNames;
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromName(sObjectName, this.getAuthenticatorCredentials(), SalesforceSchemaUtil.COMPOUND_FIELDS);
            List<String> sObjectFields = sObjectDescriptor.getFieldsNames();
            if (schema == null) {
                fieldNames = sObjectFields;
            } else {
                fieldNames = sObjectFields.stream().filter(name -> schema.getField(name) != null).collect(Collectors.toList());
                if (fieldNames.isEmpty()) {
                    throw new IllegalArgumentException(String.format("None of the fields indicated in schema are present in sObject metadata. Schema: '%s'. SObject fields: '%s'", schema, sObjectFields));
                }
            }
            SObjectFilterDescriptor filterDescriptor = this.getSObjectFilterDescriptor(logicalStartTime);
            String sObjectQuery = SalesforceQueryUtil.createSObjectQuery(fieldNames, sObjectName, filterDescriptor);
            LOG.debug("Generated SObject query: '{}'", (Object)sObjectQuery);
            return sObjectQuery;
        }
        catch (ConnectionException e) {
            throw new IllegalStateException(String.format("Cannot establish connection to Salesforce to describe SObject: '%s'", sObjectName), e);
        }
    }

    private SObjectFilterDescriptor getSObjectFilterDescriptor(long logicalStartTime) {
        ZonedDateTime start = this.parseDatetime(this.datetimeAfter);
        ZonedDateTime end = this.parseDatetime(this.datetimeBefore);
        SObjectFilterDescriptor filterDescriptor = start != null || end != null ? SObjectFilterDescriptor.interval(start, end) : SObjectFilterDescriptor.range(logicalStartTime, this.getDuration(), this.getOffset());
        return filterDescriptor;
    }

    private void validateIntervalFilterProperty(String propertyName, String datetime) {
        if (this.containsMacro(propertyName)) {
            return;
        }
        try {
            this.parseDatetime(datetime);
        }
        catch (DateTimeParseException e) {
            throw new InvalidConfigException(String.format("Invalid SObject '%s' value: '%s'. Value must be in Salesforce Date Formats. For example, 2019-01-01T23:01:01Z", propertyName, datetime), propertyName);
        }
    }

    private void validateOperationProperty(String propertyName, String operation) {
        try {
            OperationEnum.valueOf((String)operation);
        }
        catch (InvalidConfigException e) {
            throw new InvalidConfigException(String.format("Invalid Query Operation: '%s'. Valid operation values are query and queryAll.", operation), propertyName);
        }
    }

    private void validateRangeFilterProperty(String propertyName, Map<ChronoUnit, Integer> rangeValue) {
        if (this.containsMacro(propertyName) || rangeValue.isEmpty()) {
            return;
        }
        List invalidValues = rangeValue.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).collect(Collectors.toList());
        if (!invalidValues.isEmpty()) {
            throw new InvalidConfigException(String.format("Invalid SObject '%s' values: '%s'. Values must be '%d' or greater", propertyName, invalidValues, 0), propertyName);
        }
    }

    private Map<ChronoUnit, Integer> extractRangeValue(String propertyName, String rangeValue) {
        if (StringUtils.isBlank((CharSequence)rangeValue)) {
            return Collections.emptyMap();
        }
        return Stream.of(rangeValue.split(",")).map(String::trim).map(s -> s.split(" ", 2)).peek(keyValue -> this.validateUnitKeyValue(propertyName, rangeValue, (String[])keyValue)).collect(Collectors.toMap(keyValue -> this.parseUnitType(propertyName, keyValue[1]), keyValue -> this.parseUnitValue(propertyName, keyValue[0]), (o, n) -> {
            throw new InvalidConfigException(String.format("'%s' has duplicate unit types '%s'", propertyName, rangeValue), propertyName);
        }));
    }

    private void validateUnitKeyValue(String propertyName, String rangeValue, String[] keyValue) {
        if (keyValue.length < 2) {
            throw new InvalidConfigException(String.format("'%s' has invalid format '%s'. Expected format is <VALUE_1> <TYPE_1>,<VALUE_2> <TYPE_2>... . For example, '1 days, 2 hours, 30 minutes'", propertyName, rangeValue), propertyName);
        }
    }

    private ChronoUnit parseUnitType(String propertyName, String value) {
        try {
            return ChronoUnit.valueOf(value.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigException(String.format("'%s' has invalid unit type '%s'", propertyName, value), e, propertyName);
        }
    }

    private int parseUnitValue(String propertyName, String value) {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException(String.format("'%s' has invalid unit value '%s'", propertyName, value), e, propertyName);
        }
    }

    @Nullable
    private ZonedDateTime parseDatetime(String datetime) throws DateTimeParseException {
        return StringUtils.isBlank((CharSequence)datetime) ? null : ZonedDateTime.parse(datetime, DateTimeFormatter.ISO_DATE_TIME);
    }

    public String getOperation() {
        return this.operation == null ? DEFAULT_OPERATION : this.operation;
    }
}

