/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sforce.async.BulkConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Input;
import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchRuntimeContext;
import io.cdap.cdap.etl.api.batch.BatchSource;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.batch.MapToRecordTransformer;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceInputFormatProvider;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSourceConfig;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSplit;
import io.cdap.plugin.salesforce.plugin.source.batch.util.SalesforceSplitUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Plugin(type="batchsource")
@Name(value="Salesforce")
@Description(value="Read data from Salesforce.")
public class SalesforceBatchSource
extends BatchSource<Schema, Map<String, String>, StructuredRecord> {
    public static final String NAME = "Salesforce";
    private final SalesforceSourceConfig config;
    private Schema schema;
    private MapToRecordTransformer transformer;
    private Set<String> jobIds = new HashSet<String>();
    private AuthenticatorCredentials authenticatorCredentials;

    public SalesforceBatchSource(SalesforceSourceConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.config.validate(pipelineConfigurer.getStageConfigurer().getFailureCollector());
        if (this.config.containsMacro("schema")) {
            pipelineConfigurer.getStageConfigurer().setOutputSchema(null);
            return;
        }
        if (this.config.containsMacro("query") || this.config.containsMacro("sObjectName") || !this.config.canAttemptToEstablishConnection()) {
            pipelineConfigurer.getStageConfigurer().setOutputSchema(this.config.getSchema());
            return;
        }
        this.schema = this.retrieveSchema();
        pipelineConfigurer.getStageConfigurer().setOutputSchema(this.schema);
    }

    public void prepareRun(BatchSourceContext context) {
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(collector);
        collector.getOrThrowException();
        if (this.schema == null) {
            this.schema = this.retrieveSchema();
        }
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, this.config.referenceName);
        lineageRecorder.createExternalDataset(this.schema);
        lineageRecorder.recordRead("Read", "Read from Salesforce", ((List)Preconditions.checkNotNull((Object)this.schema.getFields())).stream().map(Schema.Field::getName).collect(Collectors.toList()));
        String query = this.config.getQuery(context.getLogicalStartTime());
        String sObjectName = SObjectDescriptor.fromQuery(query).getName();
        this.authenticatorCredentials = this.config.getAuthenticatorCredentials();
        BulkConnection bulkConnection = SalesforceSplitUtil.getBulkConnection(this.authenticatorCredentials);
        boolean enablePKChunk = this.config.getEnablePKChunk();
        if (enablePKChunk) {
            String parent = this.config.getParent();
            int chunkSize = this.config.getChunkSize();
            ArrayList<String> chunkHeaderValues = new ArrayList<String>();
            chunkHeaderValues.add(String.format("chunkSize=%d", chunkSize));
            if (!Strings.isNullOrEmpty((String)parent)) {
                chunkHeaderValues.add(String.format("parent=%s", parent));
            }
            bulkConnection.addHeader("Sforce-Enable-PKChunking", String.join((CharSequence)";", chunkHeaderValues));
        }
        List<SalesforceSplit> querySplits = SalesforceSplitUtil.getQuerySplits(query, bulkConnection, enablePKChunk, this.config.getOperation());
        querySplits.parallelStream().forEach(salesforceSplit -> this.jobIds.add(salesforceSplit.getJobId()));
        context.setInput(Input.of((String)this.config.referenceName, (InputFormatProvider)new SalesforceInputFormatProvider(this.config, (Map<String, String>)ImmutableMap.of((Object)sObjectName, (Object)this.schema.toString()), querySplits, null)));
    }

    public void initialize(BatchRuntimeContext context) throws Exception {
        super.initialize(context);
        this.transformer = new MapToRecordTransformer();
    }

    public void onRunFinish(boolean succeeded, BatchSourceContext context) {
        super.onRunFinish(succeeded, (BatchContext)context);
        SalesforceSplitUtil.closeJobs(this.jobIds, this.authenticatorCredentials);
    }

    public void transform(KeyValue<Schema, Map<String, String>> input, Emitter<StructuredRecord> emitter) throws Exception {
        StructuredRecord record = this.transformer.transform((Schema)input.getKey(), (Map)input.getValue());
        emitter.emit((Object)record);
    }

    private Schema getSchema(SalesforceSourceConfig config) {
        String query = config.getQuery(System.currentTimeMillis());
        SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromQuery(query);
        try {
            return SalesforceSchemaUtil.getSchema(config.getAuthenticatorCredentials(), sObjectDescriptor);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(String.format("Unable to get schema from the query '%s'", query), e);
        }
    }

    private Schema retrieveSchema() {
        Schema providedSchema = this.config.getSchema();
        Schema actualSchema = this.getSchema(this.config);
        if (providedSchema != null) {
            SalesforceSchemaUtil.checkCompatibility(actualSchema, providedSchema);
            return providedSchema;
        }
        return actualSchema;
    }
}

