/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.BulkAPIBatchException;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSplit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceBulkRecordReader
extends RecordReader<Schema, Map<String, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceBulkRecordReader.class);
    private final Schema schema;
    private CSVParser csvParser;
    private Iterator<CSVRecord> parserIterator;
    private Map<String, ?> value;
    private String jobId;
    private BulkConnection bulkConnection;
    private String batchId;
    private String[] resultIds;
    private int resultIdIndex;

    public SalesforceBulkRecordReader(Schema schema) {
        this(schema, null, null, null);
    }

    @VisibleForTesting
    SalesforceBulkRecordReader(Schema schema, String jobId, String batchId, String[] resultIds) {
        this.schema = schema;
        this.resultIdIndex = 0;
        this.jobId = jobId;
        this.batchId = batchId;
        this.resultIds = resultIds;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        SalesforceSplit salesforceSplit = (SalesforceSplit)inputSplit;
        this.jobId = salesforceSplit.getJobId();
        this.batchId = salesforceSplit.getBatchId();
        LOG.debug("Executing Salesforce Batch Id: '{}' for Job Id: '{}'", (Object)this.batchId, (Object)this.jobId);
        Configuration conf = taskAttemptContext.getConfiguration();
        try {
            AuthenticatorCredentials credentials = SalesforceConnectionUtil.getAuthenticatorCredentials(conf);
            this.bulkConnection = new BulkConnection(Authenticator.createConnectorConfig(credentials));
            this.resultIds = this.waitForBatchResults(this.bulkConnection);
            LOG.debug("Batch {} returned {} results", (Object)this.batchId, (Object)this.resultIds.length);
            this.setupParser();
        }
        catch (AsyncApiException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
    }

    public boolean nextKeyValue() throws IOException {
        if (this.parserIterator == null) {
            return false;
        }
        while (!this.parserIterator.hasNext()) {
            if (this.resultIdIndex == this.resultIds.length) {
                return false;
            }
            if (this.csvParser != null && !this.csvParser.isClosed()) {
                this.csvParser.close();
                this.csvParser = null;
            }
            try {
                this.setupParser();
            }
            catch (AsyncApiException e) {
                throw new IOException("Failed to query results", e);
            }
        }
        this.value = this.parserIterator.next().toMap();
        return true;
    }

    public Schema getCurrentKey() {
        return this.schema;
    }

    public Map<String, ?> getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() throws IOException {
        if (this.csvParser != null && !this.csvParser.isClosed()) {
            this.csvParser.close();
            this.csvParser = null;
        }
    }

    @VisibleForTesting
    void setupParser() throws IOException, AsyncApiException {
        if (this.resultIdIndex >= this.resultIds.length) {
            throw new IllegalArgumentException(String.format("Invalid resultIdIndex %d, should be less than %d", this.resultIdIndex, this.resultIds.length));
        }
        InputStream queryResponseStream = this.bulkConnection.getQueryResultStream(this.jobId, this.batchId, this.resultIds[this.resultIdIndex]);
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[0]).withQuoteMode(QuoteMode.ALL).withAllowMissingColumnNames(false);
        this.csvParser = CSVParser.parse((InputStream)queryResponseStream, (Charset)StandardCharsets.UTF_8, (CSVFormat)csvFormat);
        if (this.csvParser.getHeaderMap().isEmpty()) {
            throw new IllegalStateException("Empty response was received from Salesforce, but csv header was expected.");
        }
        this.parserIterator = this.csvParser.iterator();
        ++this.resultIdIndex;
    }

    private String[] waitForBatchResults(BulkConnection bulkConnection) throws AsyncApiException, InterruptedException {
        BatchInfo info = null;
        int i = 0;
        while ((long)i < 1200L) {
            block6: {
                try {
                    info = bulkConnection.getBatchInfo(this.jobId, this.batchId);
                }
                catch (AsyncApiException e) {
                    if ((long)i == 1199L) {
                        throw e;
                    }
                    LOG.warn("Failed to get info for batch {}. Will retry after some time.", (Object)this.batchId, (Object)e);
                    break block6;
                }
                if (info.getState() == BatchStateEnum.Completed) {
                    return bulkConnection.getQueryResultList(this.jobId, this.batchId).getResult();
                }
                if (info.getState() == BatchStateEnum.Failed) {
                    throw new BulkAPIBatchException("Batch failed", info);
                }
                LOG.debug("Batch {} job {} state {}", new Object[]{this.batchId, this.jobId, info.getState()});
                Thread.sleep(500L);
            }
            ++i;
        }
        throw new BulkAPIBatchException("Timeout waiting for batch results", info);
    }
}

