/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceQueryUtil;
import io.cdap.plugin.salesforce.parser.SalesforceQueryParser;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBulkRecordReader;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceRecordReaderWrapper;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSoapRecordReader;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSplit;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceWideRecordReader;
import io.cdap.plugin.salesforce.plugin.source.batch.SoapRecordToMapTransformer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceInputFormat
extends InputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceInputFormat.class);
    private static final Gson GSON = new Gson();
    private static final Type SCHEMAS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type QUERY_SPLITS_TYPE = new TypeToken<List<SalesforceSplit>>(){}.getType();

    public List<InputSplit> getSplits(JobContext context) {
        Configuration configuration = context.getConfiguration();
        List querySplits = (List)GSON.fromJson(configuration.get("mapred.salesforce.input.query.splits"), QUERY_SPLITS_TYPE);
        return querySplits.parallelStream().collect(Collectors.toList());
    }

    public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        SalesforceSplit multiSplit = (SalesforceSplit)split;
        String query = multiSplit.getQuery();
        SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromQuery(query);
        String sObjectName = sObjectDescriptor.getName();
        Configuration configuration = context.getConfiguration();
        String sObjectNameField = configuration.get("mapred.salesforce.input.sObjectNameField");
        Map schemas = (Map)GSON.fromJson(configuration.get("mapred.salesforce.input.schemas"), SCHEMAS_TYPE);
        Schema schema = Schema.parseJson((String)((String)schemas.get(sObjectName)));
        return new SalesforceRecordReaderWrapper(sObjectName, sObjectNameField, this.getDelegateRecordReader(query, schema));
    }

    private RecordReader<Schema, Map<String, ?>> getDelegateRecordReader(String query, Schema schema) {
        if (SalesforceQueryParser.isRestrictedQuery(query)) {
            LOG.info("The SOQL query uses an aggregate function call or offset. Reads will be performed serially and not in parallel.");
            return new SalesforceSoapRecordReader(schema, query, new SoapRecordToMapTransformer());
        }
        if (SalesforceQueryUtil.isQueryUnderLengthLimit(query)) {
            return new SalesforceBulkRecordReader(schema);
        }
        LOG.info("The SOQL query is a wide query. An additional SOAP request will be performed for each record.");
        return new SalesforceWideRecordReader(schema, query, new SoapRecordToMapTransformer());
    }
}

