/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBaseSourceConfig;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceInputFormat;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSplit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SalesforceInputFormatProvider
implements InputFormatProvider {
    private static final Gson GSON = new Gson();
    private final Map<String, String> conf;

    public SalesforceInputFormatProvider(SalesforceBaseSourceConfig config, Map<String, String> schemas, List<SalesforceSplit> querySplits, @Nullable String sObjectNameField) {
        ImmutableMap.Builder configBuilder = new ImmutableMap.Builder().put((Object)"mapred.salesforce.input.schemas", (Object)GSON.toJson(schemas));
        configBuilder.put((Object)"mapred.salesforce.input.query.splits", (Object)GSON.toJson(querySplits));
        OAuthInfo oAuthInfo = config.getOAuthInfo();
        if (oAuthInfo != null) {
            configBuilder.put((Object)"mapred.salesforce.oauth.token", (Object)oAuthInfo.getAccessToken()).put((Object)"mapred.salesforce.oauth.instance.url", (Object)oAuthInfo.getInstanceURL());
        } else {
            configBuilder.put((Object)"mapred.salesforce.user", (Object)Objects.requireNonNull(config.getUsername())).put((Object)"mapred.salesforce.password", (Object)Objects.requireNonNull(config.getPassword())).put((Object)"mapred.salesforce.consumer.key", (Object)Objects.requireNonNull(config.getConsumerKey())).put((Object)"mapred.salesforce.consumer.secret", (Object)Objects.requireNonNull(config.getConsumerSecret())).put((Object)"mapred.salesforce.login.url", (Object)Objects.requireNonNull(config.getLoginUrl()));
        }
        if (sObjectNameField != null) {
            configBuilder.put((Object)"mapred.salesforce.input.sObjectNameField", (Object)sObjectNameField);
        }
        this.conf = configBuilder.build();
    }

    public Map<String, String> getInputFormatConfiguration() {
        return this.conf;
    }

    public String getInputFormatClassName() {
        return SalesforceInputFormat.class.getName();
    }
}

