/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.base.Strings;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectsDescribeResult;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBaseSourceConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceMultiSourceConfig
extends SalesforceBaseSourceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceMultiSourceConfig.class);
    public static final String SOBJECT_NAME_FIELD_DEFAULT = "tablename";
    @Name(value="whiteList")
    @Macro
    @Nullable
    @Description(value="List of SObjects to fetch from Salesforce. By default all SObjects will be white listed")
    private String whiteList;
    @Name(value="blackList")
    @Macro
    @Nullable
    @Description(value="List of SObjects NOT to fetch from Salesforce. By default NONE of SObjects will be black listed")
    private String blackList;
    @Name(value="sObjectNameField")
    @Nullable
    @Description(value="The name of the field that holds SObject name. Must not be the name of any sObject column that will be read. Defaults to 'tablename'.")
    private String sObjectNameField;

    public SalesforceMultiSourceConfig(String referenceName, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, @Nullable String datetimeAfter, @Nullable String datetimeBefore, @Nullable String duration, @Nullable String offset, @Nullable String whiteList, @Nullable String blackList, @Nullable String sObjectNameField, @Nullable String securityToken, @Nullable OAuthInfo oAuthInfo, @Nullable String operation) {
        super(referenceName, consumerKey, consumerSecret, username, password, loginUrl, datetimeAfter, datetimeBefore, duration, offset, securityToken, oAuthInfo, operation);
        this.whiteList = whiteList;
        this.blackList = blackList;
        this.sObjectNameField = sObjectNameField;
    }

    public Set<String> getWhiteList() {
        return this.getList(this.whiteList);
    }

    public Set<String> getBlackList() {
        return this.getList(this.blackList);
    }

    public String getSObjectNameField() {
        return Strings.isNullOrEmpty((String)this.sObjectNameField) ? SOBJECT_NAME_FIELD_DEFAULT : this.sObjectNameField;
    }

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        this.validateFilters(collector);
    }

    public Map<String, Schema> getSObjectsSchemas(List<String> queries) throws ConnectionException {
        List sObjectDescriptors = queries.parallelStream().map(SObjectDescriptor::fromQuery).collect(Collectors.toList());
        PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(this.getAuthenticatorCredentials());
        Set<String> sObjectsToDescribe = sObjectDescriptors.stream().map(SObjectDescriptor::getName).collect(Collectors.toSet());
        SObjectsDescribeResult describeResult = SObjectsDescribeResult.of(partnerConnection, sObjectsToDescribe);
        return sObjectDescriptors.stream().collect(Collectors.toMap(SObjectDescriptor::getName, sObjectDescriptor -> SalesforceSchemaUtil.getSchemaWithFields(sObjectDescriptor, describeResult), (o, n) -> n));
    }

    public List<String> getQueries(long logicalStartTime) {
        List<String> queries = this.getSObjects().parallelStream().map(sObject -> this.getSObjectQuery((String)sObject, null, logicalStartTime)).collect(Collectors.toList());
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("No SObject queries are generated");
        }
        LOG.debug("Generated '{}' SObject queries", (Object)queries.size());
        return queries;
    }

    public void validateSObjects(FailureCollector collector) {
        List invalidBlackListedSObject;
        DescribeGlobalResult describeGlobalResult;
        try {
            PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(this.getAuthenticatorCredentials());
            describeGlobalResult = partnerConnection.describeGlobal();
        }
        catch (ConnectionException e) {
            throw new IllegalArgumentException("Unable to connect to Salesforce", e);
        }
        Set<String> whileList = this.getWhiteList();
        Set<String> blackList = this.getBlackList();
        List sObjects = Stream.of(describeGlobalResult.getSobjects()).filter(DescribeGlobalSObjectResult::getQueryable).map(DescribeGlobalSObjectResult::getName).collect(Collectors.toList());
        List invalidWhiteListedSObject = whileList.stream().filter(name -> !sObjects.contains(name)).collect(Collectors.toList());
        if (!invalidWhiteListedSObject.isEmpty()) {
            collector.addFailure(String.format("Invalid SObject name %s in whitelist", String.join((CharSequence)", ", invalidWhiteListedSObject)), "").withConfigProperty("whiteList");
        }
        if (!(invalidBlackListedSObject = blackList.stream().filter(name -> !sObjects.contains(name)).collect(Collectors.toList())).isEmpty()) {
            collector.addFailure(String.format("Invalid SObject name %s in blacklist", String.join((CharSequence)", ", invalidBlackListedSObject)), "").withConfigProperty("blackList");
        }
    }

    private List<String> getSObjects() {
        DescribeGlobalResult describeGlobalResult;
        try {
            PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(this.getAuthenticatorCredentials());
            describeGlobalResult = partnerConnection.describeGlobal();
        }
        catch (ConnectionException e) {
            throw new IllegalArgumentException("Unable to connect to Salesforce", e);
        }
        Set<String> whileList = this.getWhiteList();
        Set<String> blackList = this.getBlackList();
        List<String> sObjects = Stream.of(describeGlobalResult.getSobjects()).filter(DescribeGlobalSObjectResult::getQueryable).map(DescribeGlobalSObjectResult::getName).filter(name -> whileList.isEmpty() || whileList.contains(name)).filter(name -> !blackList.contains(name)).collect(Collectors.toList());
        if (sObjects.isEmpty()) {
            throw new IllegalArgumentException("No qualified SObjects are found");
        }
        LOG.debug("SObjects to be replicated: '{}'", sObjects);
        return sObjects;
    }

    private Set<String> getList(String value) {
        return Strings.isNullOrEmpty((String)value) ? Collections.emptySet() : Stream.of(value.split(",")).map(String::trim).filter(name -> !name.isEmpty()).collect(Collectors.toSet());
    }
}

