/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import io.cdap.cdap.api.data.schema.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SalesforceRecordReaderWrapper
extends RecordReader<Schema, Map<String, ?>> {
    private final String sObjectName;
    private final String sObjectNameField;
    private final RecordReader<Schema, Map<String, ?>> delegate;

    public SalesforceRecordReaderWrapper(String sObjectName, @Nullable String sObjectNameField, RecordReader<Schema, Map<String, ?>> delegate) {
        this.sObjectName = sObjectName;
        this.sObjectNameField = sObjectNameField;
        this.delegate = delegate;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.delegate.initialize(split, context);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.delegate.nextKeyValue();
    }

    public Schema getCurrentKey() throws IOException, InterruptedException {
        return (Schema)this.delegate.getCurrentKey();
    }

    public Map<String, ?> getCurrentValue() throws IOException, InterruptedException {
        Map currentValue = (Map)this.delegate.getCurrentValue();
        if (this.sObjectNameField == null) {
            return currentValue;
        }
        HashMap<String, String> updatedCurrentValue = new HashMap<String, String>(currentValue);
        updatedCurrentValue.put(this.sObjectNameField, this.sObjectName);
        return updatedCurrentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.delegate.getProgress();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

