/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.batch.SoapRecordToMapTransformer;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceSoapRecordReader
extends RecordReader<Schema, Map<String, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSoapRecordReader.class);
    private final Schema schema;
    private final String query;
    private final SoapRecordToMapTransformer transformer;
    private SObjectDescriptor sObjectDescriptor;
    private PartnerConnection partnerConnection;
    private QueryResult queryResult;
    private SObject[] sObjects;
    private int index;
    private Map<String, ?> value;

    public SalesforceSoapRecordReader(Schema schema, String query, SoapRecordToMapTransformer transformer) {
        this.schema = schema;
        this.query = query;
        this.transformer = transformer;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        LOG.debug("Executing Salesforce SOAP query: '{}'", (Object)this.query);
        Configuration conf = taskAttemptContext.getConfiguration();
        try {
            AuthenticatorCredentials credentials = SalesforceConnectionUtil.getAuthenticatorCredentials(conf);
            this.partnerConnection = SalesforceConnectionUtil.getPartnerConnection(credentials);
            this.sObjectDescriptor = SObjectDescriptor.fromQuery(this.query);
            this.queryResult = this.partnerConnection.query(this.query);
        }
        catch (ConnectionException e) {
            throw new RuntimeException("Cannot create Salesforce SOAP connection", e);
        }
    }

    public boolean nextKeyValue() throws IOException {
        if (this.readValue()) {
            return true;
        }
        if (this.queryResult.isDone()) {
            return false;
        }
        this.queryMore();
        return this.readValue();
    }

    public Schema getCurrentKey() {
        return this.schema;
    }

    public Map<String, ?> getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() {
    }

    private boolean readValue() {
        if (this.sObjects == null) {
            this.index = 0;
            this.sObjects = this.queryResult.getRecords();
        }
        if (this.sObjects.length > this.index) {
            this.value = this.transformer.transformToMap(this.sObjects[this.index++], this.sObjectDescriptor);
            return true;
        }
        return false;
    }

    private void queryMore() throws IOException {
        try {
            this.sObjects = null;
            this.queryResult = this.partnerConnection.queryMore(this.queryResult.getQueryLocator());
        }
        catch (ConnectionException e) {
            throw new IOException(String.format("Cannot create Salesforce SOAP connection for query locator: '%s'", this.queryResult.getQueryLocator()), e);
        }
    }
}

