/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.salesforce.InvalidConfigException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectsDescribeResult;
import io.cdap.plugin.salesforce.SalesforceQueryUtil;
import io.cdap.plugin.salesforce.SalesforceSchemaUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.parser.SOQLParsingException;
import io.cdap.plugin.salesforce.parser.SalesforceQueryParser;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBaseSourceConfig;
import io.cdap.plugin.salesforce.plugin.source.batch.util.SalesforceSourceConstants;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SalesforceSourceConfig
extends SalesforceBaseSourceConfig {
    @Name(value="query")
    @Description(value="The SOQL query to retrieve results from. Example: select Id, Name from Opportunity")
    @Nullable
    @Macro
    private String query;
    @Name(value="sObjectName")
    @Description(value="Salesforce SObject name. Example: Opportunity")
    @Nullable
    @Macro
    private String sObjectName;
    @Name(value="schema")
    @Macro
    @Nullable
    @Description(value="Schema of the data to read. Can be imported or fetched by clicking the `Get Schema` button.")
    private String schema;
    @Name(value="enablePKChunk")
    @Macro
    @Nullable
    @Description(value="Primary key (PK) Chunking splits query on large tables into chunks based on the record IDs, or primary keys, of the queried records.")
    private Boolean enablePKChunk;
    @Name(value="chunkSize")
    @Macro
    @Nullable
    @Description(value="Specify size of chunk. Maximum Size is 250,000. Default Size is 100,000.")
    private Integer chunkSize;
    @Name(value="parent")
    @Macro
    @Nullable
    @Description(value="Parent of the Salesforce Object. This is used to enable chunking for history tables or shared objects.")
    private String parent;

    @VisibleForTesting
    SalesforceSourceConfig(String referenceName, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, @Nullable String query, @Nullable String sObjectName, @Nullable String datetimeAfter, @Nullable String datetimeBefore, @Nullable String duration, @Nullable String offset, @Nullable String schema, @Nullable String securityToken, @Nullable String operation, @Nullable OAuthInfo oAuthInfo, @Nullable Boolean enablePKChunk, @Nullable Integer chunkSize, @Nullable String parent) {
        super(referenceName, consumerKey, consumerSecret, username, password, loginUrl, datetimeAfter, datetimeBefore, duration, offset, securityToken, oAuthInfo, operation);
        this.query = query;
        this.sObjectName = sObjectName;
        this.schema = schema;
        this.enablePKChunk = enablePKChunk;
        this.chunkSize = chunkSize;
        this.parent = parent;
    }

    public String getQuery(long logicalStartTime) {
        String soql = this.isSoqlQuery() ? this.query : this.getSObjectQuery(this.sObjectName, this.getSchema(), logicalStartTime);
        return Objects.requireNonNull(soql).trim();
    }

    @Nullable
    public String getSObjectName() {
        return this.sObjectName;
    }

    public String getParent() {
        return this.parent == null ? "" : this.parent;
    }

    @Nullable
    public Schema getSchema() {
        try {
            return Strings.isNullOrEmpty((String)this.schema) ? null : Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            throw new InvalidConfigException("Unable to parse output schema: " + this.schema, e, "schema");
        }
    }

    public boolean isSoqlQuery() {
        if (!Strings.isNullOrEmpty((String)this.query)) {
            return true;
        }
        if (!Strings.isNullOrEmpty((String)this.sObjectName)) {
            return false;
        }
        throw new InvalidConfigException("SOQL query or SObject name must be provided", "query");
    }

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        if (!this.containsMacro("query") && !Strings.isNullOrEmpty((String)this.query)) {
            SObjectDescriptor queryDescriptor;
            if (!SalesforceQueryUtil.isQueryUnderLengthLimit(this.query) && SalesforceQueryParser.isRestrictedQuery(this.query)) {
                collector.addFailure(String.format("SOQL Query with restricted field types (function calls, sub-query fields) or GROUP BY [ROLLUP / CUBE], OFFSET clauses cannot exceed SOQL query length: '%d'. Unsupported SOQL query: '%s'", 20000, this.query), null).withConfigProperty("query");
                throw collector.getOrThrowException();
            }
            try {
                queryDescriptor = SalesforceQueryParser.getObjectDescriptorFromQuery(this.query);
            }
            catch (SOQLParsingException e) {
                collector.addFailure(String.format("Invalid SOQL query '%s' : %s", this.query, e.getMessage()), null).withStacktrace(e.getStackTrace()).withConfigProperty("query");
                throw collector.getOrThrowException();
            }
            if (this.canAttemptToEstablishConnection()) {
                this.validateCompoundFields(queryDescriptor.getName(), queryDescriptor.getFieldsNames(), collector);
            }
        }
        if (!this.containsMacro("query") && !this.containsMacro("sObjectName")) {
            try {
                boolean isSoql = this.isSoqlQuery();
                if (!isSoql) {
                    this.validateFilters(collector);
                }
            }
            catch (InvalidConfigException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
            }
        }
        this.validateSchema(collector);
        this.validatePKChunk(collector);
    }

    private void validateSchema(FailureCollector collector) {
        if (this.containsMacro("schema")) {
            return;
        }
        try {
            Schema schema = this.getSchema();
            if (schema != null) {
                SalesforceSchemaUtil.validateFieldSchemas(schema, collector);
            }
        }
        catch (InvalidConfigException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(e.getProperty());
        }
    }

    private void validateCompoundFields(String sObjectName, List<String> fieldNames, FailureCollector collector) {
        try {
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromName(sObjectName, this.getAuthenticatorCredentials());
            List compoundFieldNames = sObjectDescriptor.getFields().stream().filter(fieldDescriptor -> fieldNames.contains(fieldDescriptor.getName())).filter(fieldDescriptor -> SalesforceSchemaUtil.COMPOUND_FIELDS.contains(fieldDescriptor.getFieldType())).map(SObjectDescriptor.FieldDescriptor::getName).collect(Collectors.toList());
            if (!compoundFieldNames.isEmpty()) {
                collector.addFailure(String.format("Compound fields %s cannot be fetched when a SOQL query is given. Please specify the individual attributes instead of compound field name in SOQL query. For example, instead of 'Select BillingAddress ...', use 'Select BillingCountry, BillingCity, BillingStreet ...'", compoundFieldNames), null).withConfigProperty("query");
            }
        }
        catch (ConnectionException e) {
            collector.addFailure(String.format("Cannot establish connection to Salesforce to describe SObject: '%s'", sObjectName), null).withStacktrace(e.getStackTrace());
        }
    }

    private void validatePKChunk(FailureCollector collector) {
        if (this.containsMacro("enablePKChunk") || this.containsMacro("chunkSize") || this.containsMacro("parent")) {
            return;
        }
        if (!this.getEnablePKChunk()) {
            return;
        }
        if (!this.containsMacro("query") && !Strings.isNullOrEmpty((String)this.query)) {
            if (SalesforceQueryParser.isRestrictedPKQuery(this.query)) {
                collector.addFailure(String.format("SOQL Query contains restricted clauses when PK Chunk is Enabled. Unsupported query: '%s'.", this.query), "Set Enable PK Chunk to false, because 'WHERE' is the only supported conditions clause.").withConfigProperty("query");
            }
            if (!this.containsMacro("parent") && !Strings.isNullOrEmpty((String)this.getParent())) {
                this.checkForPKSupportedObject(this.getParent(), collector);
            } else {
                String sObject = SalesforceQueryParser.getObjectDescriptorFromQuery(this.query).getName();
                this.checkForPKSupportedObject(sObject, collector);
            }
        }
        if (!this.containsMacro("sObjectName") && !Strings.isNullOrEmpty((String)this.getSObjectName())) {
            if (!this.containsMacro("parent") && !Strings.isNullOrEmpty((String)this.getParent())) {
                this.checkForPKSupportedObject(this.getParent(), collector);
            } else {
                this.checkForPKSupportedObject(this.getSObjectName(), collector);
            }
        }
        if (this.getChunkSize() > 250000) {
            collector.addFailure(String.format("Chunk Size '%d' is bigger than maximum allowed size '%d'.", this.getChunkSize(), 250000), String.format("Allowed values are between the range of '%d' and '%d'.", 1, 250000)).withConfigProperty("chunkSize");
        } else if (this.getChunkSize() < 1) {
            collector.addFailure(String.format("Chunk Size %d is lower than minimum allowed size '%d'.", this.getChunkSize(), 1), String.format("Allowed values are between the range of '%d' and '%d'.", 1, 250000)).withConfigProperty("chunkSize");
        }
    }

    private void checkForPKSupportedObject(String sObject, FailureCollector collector) {
        if (this.canAttemptToEstablishConnection() && !this.isCustomObject(sObject, collector) && !SalesforceSourceConstants.SUPPORTED_OBJECTS_WITH_PK_CHUNK.contains(sObject)) {
            collector.addFailure(String.format("SObject '%s' is not supported with PKChunk enabled.", sObject), "Please check documentation for supported Objects. If this is a history or shared table, you may need to specify a SObject Parent in the Advanced section.");
        }
    }

    public boolean getEnablePKChunk() {
        return this.enablePKChunk == null ? false : this.enablePKChunk;
    }

    public int getChunkSize() {
        return this.chunkSize == null ? 100000 : this.chunkSize;
    }

    private boolean isCustomObject(String sObjectName, FailureCollector collector) {
        AuthenticatorCredentials credentials = this.getAuthenticatorCredentials();
        try {
            PartnerConnection partnerConnection = new PartnerConnection(Authenticator.createConnectorConfig(credentials));
            return SObjectsDescribeResult.isCustomObject(partnerConnection, sObjectName);
        }
        catch (ConnectionException e) {
            collector.addFailure("There was issue communicating with Salesforce", null).withStacktrace(e.getStackTrace());
            throw collector.getOrThrowException();
        }
    }
}

