/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.google.common.collect.Lists;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceConnectionUtil;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBulkRecordReader;
import io.cdap.plugin.salesforce.plugin.source.batch.SoapRecordToMapTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceWideRecordReader
extends SalesforceBulkRecordReader {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceWideRecordReader.class);
    private final String query;
    private final SoapRecordToMapTransformer transformer;
    private List<Map<String, ?>> results;
    private Map<String, ?> value;
    private int index;

    public SalesforceWideRecordReader(Schema schema, String query, SoapRecordToMapTransformer transformer) {
        super(schema);
        this.query = query;
        this.transformer = transformer;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        List<Map<String, ?>> fetchedIdList = this.fetchBulkQueryIds(inputSplit, taskAttemptContext);
        LOG.debug("Number of records received from batch job for wide object: '{}'", (Object)fetchedIdList.size());
        Configuration conf = taskAttemptContext.getConfiguration();
        try {
            AuthenticatorCredentials credentials = SalesforceConnectionUtil.getAuthenticatorCredentials(conf);
            PartnerConnection partnerConnection = SalesforceConnectionUtil.getPartnerConnection(credentials);
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromQuery(this.query);
            List<String> fieldsNames = sObjectDescriptor.getFieldsNames();
            String fields = String.join((CharSequence)",", fieldsNames);
            String sObjectName = sObjectDescriptor.getName();
            List partitions = Lists.partition(fetchedIdList, (int)2000);
            LOG.debug("Number of partitions to be fetched for wide object: '{}'", (Object)partitions.size());
            this.results = partitions.parallelStream().map(this::getSObjectIds).map(sObjectIds -> this.fetchPartition(partnerConnection, fields, sObjectName, (String[])sObjectIds)).flatMap(Arrays::stream).map(sObject -> this.transformer.transformToMap((SObject)sObject, sObjectDescriptor)).collect(Collectors.toList());
        }
        catch (ConnectionException e) {
            throw new RuntimeException("Cannot create Salesforce SOAP connection", e);
        }
    }

    @Override
    public boolean nextKeyValue() {
        if (this.results.size() == this.index) {
            return false;
        }
        this.value = this.results.get(this.index++);
        return true;
    }

    @Override
    public Map<String, ?> getCurrentValue() {
        return this.value;
    }

    @Override
    public float getProgress() {
        return this.results == null || this.results.isEmpty() ? 0.0f : (float)this.index / (float)this.results.size();
    }

    private List<Map<String, ?>> fetchBulkQueryIds(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        super.initialize(inputSplit, taskAttemptContext);
        ArrayList fetchedIdList = new ArrayList();
        while (super.nextKeyValue()) {
            fetchedIdList.add((Map<String, ?>)super.getCurrentValue());
        }
        return fetchedIdList;
    }

    private String[] getSObjectIds(List<Map<String, ?>> subIds) {
        return (String[])subIds.stream().map(Map::values).flatMap(Collection::stream).toArray(String[]::new);
    }

    private SObject[] fetchPartition(PartnerConnection partnerConnection, String fields, String sObjectName, String[] sObjectIds) {
        try {
            return partnerConnection.retrieve(fields, sObjectName, sObjectIds);
        }
        catch (ConnectionException e) {
            LOG.trace("Fetched SObject name: '{}', fields: '{}', Ids: '{}'", new Object[]{sObjectName, fields, String.join((CharSequence)",", sObjectIds)});
            throw new RuntimeException(String.format("Cannot retrieve data for SObject '%s'", sObjectName), e);
        }
    }
}

